/*
 * Decompiled with CFR 0.152.
 */
package consulting.omnia.util.classloader.visitor;

import consulting.omnia.util.classloader.elements.ClassFile;
import consulting.omnia.util.classloader.elements.Directory;
import consulting.omnia.util.classloader.elements.JarPath;
import consulting.omnia.util.classloader.elements.PathUtil;
import consulting.omnia.util.classloader.visitor.ClassLoaderVisitor;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class DirectoryTypeScanner
implements ClassLoaderVisitor {
    private static final String JAR = ".jar";
    private static final String CLASS = ".class";
    private final List<Class<?>> result;
    private final Class<?> type;
    private final String packageName;
    private String rootDirPath;

    public DirectoryTypeScanner(Class<?> type, String packageName) {
        this.type = type;
        this.packageName = packageName;
        this.result = new LinkedList();
    }

    public List<Class<?>> scan(Directory rootDir) {
        this.rootDirPath = PathUtil.asJavaPath(rootDir.getAbstractPath());
        this.visit(rootDir);
        return this.result;
    }

    @Override
    public void visit(Directory value) {
        for (File abstractPath : value.listFiles()) {
            if (abstractPath.isDirectory()) {
                Directory directory = new Directory(abstractPath);
                this.visit(directory);
                continue;
            }
            if (!abstractPath.isFile()) continue;
            this.visit(abstractPath);
        }
    }

    @Override
    public void visit(File file) {
        if (file.getAbsolutePath().endsWith(CLASS)) {
            ClassFile classFile = new ClassFile(file);
            this.visit(classFile);
        }
        if (file.getAbsolutePath().endsWith(JAR)) {
            JarPath jarFile = new JarPath(file);
            this.visit(jarFile);
        }
    }

    @Override
    public void visit(ClassFile value) {
        try {
            String classname = PathUtil.asJavaPath(value.getAbstractPath());
            classname = classname.replace(CLASS, "");
            String pathPrefix = this.rootDirPath.replace(this.packageName, "");
            if (!pathPrefix.endsWith("/")) {
                pathPrefix = pathPrefix + "/";
            }
            classname = classname.replace(pathPrefix, "");
            Class<?> klass = Class.forName(classname = classname.replace("/", "."));
            if (!this.type.isAssignableFrom(klass)) break block5;
            if (!this.type.equals(klass)) {
                this.result.add(klass);
            }
        }
        finally {
            return;
        }
        {
            block5: {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void visit(JarPath value) {
        JarFile jar = null;
        try {
            jar = new JarFile(value.getAbstractPath());
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry jarEntry = entries.nextElement();
                String entryName = jarEntry.getName();
                if (!entryName.endsWith(CLASS)) continue;
                ClassFile classFile = new ClassFile(value.getAbstractPath());
                this.visit(classFile);
            }
            if (jar == null) return;
        }
        catch (Throwable e) {
            if (jar == null) return;
            try {
                jar.close();
                return;
            }
            catch (IOException e2) {
                // empty catch block
            }
            return;
        }
        catch (Throwable throwable) {
            if (jar == null) throw throwable;
            try {
                jar.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            jar.close();
            return;
        }
        catch (IOException e) {
            return;
        }
    }
}

