package consulting.omnia.util.classloader;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;

import consulting.omnia.util.cast.CastUtil;
import consulting.omnia.util.classloader.elements.Directory;
import consulting.omnia.util.classloader.visitor.DirectoryTypeScanner;

public class ClassLoaderScanner {

	private final List<Class<?>> foundTypes;

	public ClassLoaderScanner() {
		this.foundTypes = new LinkedList<Class<?>>();
	}

	public <R> List<Class<R>> scan(final Class<R> type) throws IOException, ClassNotFoundException {
		final ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
		final Enumeration<URL> resources = contextClassLoader.getResources("");

		while (resources.hasMoreElements()) {
			final URL resource = resources.nextElement();
			final String path = resource.getPath();
			if (path != null && !path.isEmpty()) {
				final Directory rootDir = new Directory(new File(path));
				final DirectoryTypeScanner scanner = new DirectoryTypeScanner(type);
				foundTypes.addAll(scanner.scan(rootDir));
			}
		}
		return CastUtil.getAsList(foundTypes);
	}
	
}
