package consulting.omnia.util.cast;

public class CastExceptionUtil {

	protected static RuntimeException castException(final Class<?> type) {
		return new UnsupportedOperationException(exceptionMsg(type));
	}

	protected static RuntimeException castException(final Object value, final Class<?> type) {
		return new UnsupportedOperationException(exceptionMsg(value, type));
	}

	protected static RuntimeException castException(final String message) {
		return new UnsupportedOperationException(message);
	}

	
	private static String exceptionMsg(final Class<?> type) {
		return "Cannot cast to: [" + type.getCanonicalName() + "]";
	}

	
	private static String exceptionMsg(final Object value, final Class<?> type) {
		return "Cannot cast [" + value + "] to: [" + type.getCanonicalName() + "]";
	}

}
