package consulting.omnia.util.cast;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class BooleanCastUtil extends AbstractCastUtil {

	// True, Verdadero, Vrai, Verdadeiro, Vero, Richtig
	private static final Map<Locale, String> trueStrings = new HashMap<Locale, String>();
	private static final Map<Locale, Character> trueChars = new HashMap<Locale, Character>();
	// False, Falso, Faux, Falso, Falso, Falsch
	private static final Map<Locale, String> falseStrings = new HashMap<Locale, String>();
	private static final Map<Locale, Character> falseChars = new HashMap<Locale, Character>();
	
	static {
		put(Locale.ENGLISH, "true", 'T', "false", 'F');
		put(new Locale("es"), "verdadero", 'V', "falso", 'F');
		put(Locale.FRENCH, "vrai", 'V', "faux", 'F');
		put(new Locale("pt"), "verdadeiro", 'V', "falso", 'F');
		put(Locale.ITALIAN, "vero", 'V', "falso", 'F');
		put(Locale.GERMAN, "richtig", 'R', "falsch", 'F');
	}

	protected static void put(final Locale locale, final String trueValue, final Character trueChar, final String falseValue, final Character falseChar) {
		trueChars.put(locale, trueChar);
		falseChars.put(locale, falseChar);
		trueStrings.put(locale, trueValue);
		falseStrings.put(locale, falseValue);
	}
	
	protected static Boolean cast(final Object value) {
		return castAs(value, Boolean.class);
	}

	protected static Boolean stringToBoolean(final String value) {
		return trueStrings.containsValue(value);	
		
	}
	
	protected static Boolean charToBoolean(final Character value) {
		return trueChars.containsValue(value);	
	}

	protected static String booleanToString(final Boolean value, Locale locale) {
		if(locale == null && !trueStrings.containsKey(locale)) {
			locale = Locale.ENGLISH;
		}
		
		return value ? trueStrings.get(locale) : falseStrings.get(locale);

	}
	
	protected static Character booleanToChar(final Boolean value, Locale locale) {
		if(locale == null && !trueChars.containsKey(locale)) {
			locale = Locale.ENGLISH;
		}
		
		return value ? trueChars.get(locale) : falseChars.get(locale);

	}
	
}
