/*
 * Decompiled with CFR 0.152.
 */
package inspired.pdf.unbox.internal;

import inspired.pdf.unbox.Align;
import inspired.pdf.unbox.Bounds;
import inspired.pdf.unbox.Font;
import inspired.pdf.unbox.VAlign;
import inspired.pdf.unbox.internal.PdfUnboxException;
import inspired.pdf.unbox.internal.TextTokenizer;
import java.io.IOException;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.util.Matrix;

public class TextWriter {
    public static final float CORRECTION_FACTOR = 0.25f;
    private final Font font;
    private boolean overflow;

    public TextWriter(Font font) {
        this.font = font;
    }

    public TextWriter withOverflow(boolean overflow) {
        this.overflow = true;
        return this;
    }

    public float calculateHeight(String text, Bounds viewPort, Integer lineLimit) {
        List<String> lines = this.chunk(text, viewPort.width());
        int count = Math.max(1, lines.size());
        if (lineLimit != null && count > lineLimit) {
            count = lineLimit;
        }
        return (float)count * this.font.lineHeight();
    }

    public float calculateHeightVerticalText(String text) {
        return this.font.width(text);
    }

    public float write(PDPageContentStream contentStream, Bounds bounds, String text) {
        return this.write(contentStream, bounds, text, Align.LEFT, VAlign.TOP);
    }

    public float write(PDPageContentStream stream, Bounds bounds, String text, Align align) {
        return this.write(stream, bounds, text, align, VAlign.TOP);
    }

    public float write(PDPageContentStream stream, Bounds bounds, String text, Align align, VAlign vAlign) {
        return this.write(stream, bounds, text, align, vAlign, null);
    }

    public float write(PDPageContentStream stream, Bounds bounds, String text, Align align, VAlign vAlign, Integer lineLimit) {
        List<String> chunks = this.chunk(text, bounds.width());
        if (lineLimit != null && lineLimit > 0 && lineLimit < chunks.size()) {
            chunks = chunks.subList(0, lineLimit);
        }
        float y = this.offsetY(bounds, vAlign, chunks.size());
        return this.write(chunks, bounds, align, stream, y);
    }

    public float writeVerticalText(PDPageContentStream contentStream, Bounds bounds, String text) {
        float textLength = this.calculateHeightVerticalText(text);
        float correction = this.font.lineHeight() * 0.25f;
        float offsetX = (bounds.width() + this.font.lineHeight() - correction) / 2.0f;
        float offsetY = (bounds.height() + textLength) / 2.0f;
        try {
            contentStream.beginText();
            contentStream.setNonStrokingColor(this.font.getColor());
            contentStream.setFont(this.font.getFont(), this.font.getSize());
            contentStream.newLineAtOffset(offsetX, offsetY);
            Matrix matrix = Matrix.getRotateInstance((double)Math.toRadians(90.0), (float)(bounds.left() + offsetX), (float)(bounds.top() - offsetY));
            contentStream.setTextMatrix(matrix);
            contentStream.showText(text);
            contentStream.endText();
        }
        catch (IOException e) {
            throw new PdfUnboxException(e);
        }
        return textLength;
    }

    private float write(List<String> chunks, Bounds bounds, Align align, PDPageContentStream stream, float y) {
        if (chunks.isEmpty()) {
            return 0.0f;
        }
        int index = 0;
        while (index < chunks.size() && this.enoughSpace(bounds, index)) {
            String chunk = chunks.get(index++);
            float x = this.offsetX(bounds, chunk, align);
            this.writeLine(stream, chunk, x, y);
            y -= this.font.lineHeight();
        }
        return (float)index * this.font.lineHeight();
    }

    private boolean enoughSpace(Bounds bounds, int index) {
        float lineHeight = this.font.lineHeight() * 0.99f;
        return this.overflow || (float)(index + 1) * lineHeight <= bounds.height();
    }

    private List<String> chunk(String text, float maxWidth) {
        return new TextTokenizer(this.font).chunkMultiLine(text, maxWidth);
    }

    private void writeLine(PDPageContentStream contentStream, String text, float x, float y) {
        try {
            contentStream.beginText();
            contentStream.setNonStrokingColor(this.font.getColor());
            contentStream.setFont(this.font.getFont(), this.font.getSize());
            contentStream.newLineAtOffset(x, y);
            contentStream.showText(text);
            contentStream.endText();
        }
        catch (IOException e) {
            throw new PdfUnboxException(e);
        }
    }

    private float offsetX(Bounds bounds, String text, Align align) {
        float textWidth = this.font.width(text);
        return switch (align) {
            default -> throw new IncompatibleClassChangeError();
            case Align.LEFT -> bounds.left();
            case Align.CENTER -> (int)(bounds.center() - textWidth / 2.0f);
            case Align.RIGHT -> (int)(bounds.left() + bounds.width() - textWidth);
        };
    }

    private float offsetY(Bounds bounds, VAlign vAlign, int numLines) {
        float lineHeight = this.font.lineHeight();
        float correction = lineHeight * 0.25f;
        return switch (vAlign) {
            default -> throw new IncompatibleClassChangeError();
            case VAlign.TOP -> bounds.top() - lineHeight + correction;
            case VAlign.MIDDLE -> bounds.top() - bounds.height() / 2.0f + (float)numLines * lineHeight / 2.0f - lineHeight + correction;
            case VAlign.BOTTOM -> bounds.top() - bounds.height() + (float)numLines * lineHeight - lineHeight + correction;
        };
    }
}

