/*
 * Decompiled with CFR 0.152.
 */
package inspired.pdf.unbox.elements;

import inspired.pdf.unbox.Bounds;
import inspired.pdf.unbox.Document;
import inspired.pdf.unbox.Font;
import inspired.pdf.unbox.Margin;
import inspired.pdf.unbox.Stroke;
import inspired.pdf.unbox.base.TableModel;
import inspired.pdf.unbox.decorators.Decorator;
import inspired.pdf.unbox.elements.TableRow;
import inspired.pdf.unbox.elements.internal.AbstractTable;

public class FixedColumnsTable
extends AbstractTable {
    private final TableModel model;

    public FixedColumnsTable(TableModel model) {
        this.model = model;
    }

    public FixedColumnsTable withHeader() {
        this.addHeader(TableRow.header(this.model, new Decorator[0]));
        return this;
    }

    public FixedColumnsTable withHeader(Font font, Decorator ... decorators) {
        this.addHeader(TableRow.header(this.model, font, decorators));
        return this;
    }

    @Override
    public FixedColumnsTable with(Decorator decorator) {
        super.with(decorator);
        return this;
    }

    @Override
    public FixedColumnsTable with(Margin margin) {
        super.with(margin);
        return this;
    }

    @Override
    public FixedColumnsTable with(Stroke stroke) {
        super.with(stroke);
        return this;
    }

    public TableModel getModel() {
        return this.model;
    }

    @Override
    public TableRow addRow() {
        return this.addRow(new TableRow(this.model));
    }

    @Override
    protected float renderRow(Document document, TableRow row) {
        float rowHeight = super.renderRow(document, row);
        Bounds bounds = this.effectiveViewport(document).height(rowHeight);
        TableModel columns = this.model.scaleToSize(bounds.width());
        this.drawColumnLines(document, columns, bounds);
        return rowHeight;
    }
}

