/*
 * Decompiled with CFR 0.152.
 */
package inspired.pdf.unbox.elements;

import inspired.pdf.unbox.Bounds;
import inspired.pdf.unbox.Document;
import inspired.pdf.unbox.Font;
import inspired.pdf.unbox.elements.Paragraph;
import inspired.pdf.unbox.internal.SimpleFont;

public class VerticalParagraph
extends Paragraph {
    public VerticalParagraph(String text) {
        this(text, SimpleFont.helvetica(8.0f));
    }

    public VerticalParagraph(String text, Font font) {
        super(text.replace("\n", ""), font);
    }

    @Override
    public float render(Document document, Bounds viewPort) {
        float calculatedHeight = this.innerHeight(viewPort) + this.renderingHints().getExtraPadding().vertical();
        this.applyDecorators(document, viewPort.apply(this.margin).height(calculatedHeight));
        Bounds bounds = this.effectiveBounds(viewPort, calculatedHeight);
        float actualHeight = this.textWriter.writeVerticalText(document.getContentStream(), bounds, this.text);
        if (this.innerHeight > -1.0f) {
            return this.innerHeight + this.margin.vertical();
        }
        return actualHeight + this.padding.vertical() + this.margin.vertical() + this.renderingHints().getExtraPadding().vertical();
    }

    @Override
    public float innerHeight(Bounds viewPort) {
        if (this.innerHeight > -1.0f) {
            return this.innerHeight;
        }
        return this.textWriter.calculateHeightVerticalText(this.text) + this.padding.vertical();
    }

    @Override
    public String toString() {
        return "VerticalParagraph['" + this.text + "']";
    }
}

