/*
 * Decompiled with CFR 0.152.
 */
package inspired.pdf.unbox.elements;

import inspired.pdf.unbox.Align;
import inspired.pdf.unbox.Bounds;
import inspired.pdf.unbox.Document;
import inspired.pdf.unbox.Font;
import inspired.pdf.unbox.Margin;
import inspired.pdf.unbox.Padding;
import inspired.pdf.unbox.VAlign;
import inspired.pdf.unbox.elements.PdfElement;
import inspired.pdf.unbox.elements.internal.AbstractDecoratable;
import inspired.pdf.unbox.internal.SimpleFont;
import inspired.pdf.unbox.internal.TextWriter;

public class Paragraph
extends AbstractDecoratable
implements PdfElement {
    protected static final float HEIGHT_UNDEFINED = -1.0f;
    protected final TextWriter textWriter;
    protected final String text;
    protected Align align = Align.LEFT;
    protected VAlign vAlign = VAlign.TOP;
    protected float innerHeight = -1.0f;
    protected Padding padding = Padding.of(2.0f);
    protected Margin margin = Margin.none();
    private Integer lineLimit = null;

    public Paragraph(String text) {
        this(text, SimpleFont.helvetica(8.0f));
    }

    public Paragraph(String text, Font font) {
        this.textWriter = new TextWriter(font);
        this.text = text;
    }

    public Paragraph with(Margin margin) {
        this.margin = margin;
        return this;
    }

    public Paragraph with(Padding padding) {
        this.padding = padding;
        return this;
    }

    public Paragraph align(Align align) {
        this.align = align;
        return this;
    }

    public Paragraph align(VAlign vAlign) {
        this.vAlign = vAlign;
        return this;
    }

    public Paragraph align(Align align, VAlign vAlign) {
        this.align = align;
        this.vAlign = vAlign;
        return this;
    }

    public Paragraph withInnerHeight(float height) {
        this.innerHeight = height;
        return this;
    }

    public Paragraph limit(int lineLimit) {
        if (lineLimit <= 0) {
            return this;
        }
        this.lineLimit = lineLimit;
        return this;
    }

    @Override
    public float render(Document document, Bounds viewPort) {
        float calculatedHeight = this.innerHeight(viewPort) + this.renderingHints().getExtraPadding().vertical();
        this.applyDecorators(document, viewPort.apply(this.margin).height(calculatedHeight));
        Bounds bounds = this.effectiveBounds(viewPort, calculatedHeight);
        float actualHeight = this.textWriter.write(document.getContentStream(), bounds, this.text, this.align, this.vAlign, this.lineLimit);
        if (this.innerHeight > -1.0f) {
            return this.innerHeight + this.margin.vertical();
        }
        return actualHeight + this.padding.vertical() + this.margin.vertical() + this.renderingHints().getExtraPadding().vertical();
    }

    @Override
    public Margin margin() {
        return this.margin;
    }

    @Override
    public float innerHeight(Bounds viewPort) {
        if (this.innerHeight > -1.0f) {
            return this.innerHeight;
        }
        return this.textWriter.calculateHeight(this.text, viewPort.apply(this.padding), this.lineLimit) + this.padding.vertical();
    }

    @Override
    public float outerHeight(Bounds viewPort) {
        return super.outerHeight(viewPort);
    }

    public String toString() {
        return "Paragraph['" + this.text + "']";
    }

    protected Bounds effectiveBounds(Bounds viewPort, float calculatedHeight) {
        if (this.innerHeight > -1.0f) {
            return viewPort.apply(this.margin).height(this.innerHeight).apply(this.padding);
        }
        return viewPort.apply(this.margin).height(calculatedHeight).apply(this.padding);
    }
}

