/*
 * Decompiled with CFR 0.152.
 */
package inspired.pdf.unbox.internal;

import inspired.pdf.unbox.Font;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TextTokenizer {
    private final Font font;

    public TextTokenizer(Font font) {
        this.font = font;
    }

    public List<String> chunkMultiLine(String text, float maxWidth) {
        String[] lines;
        ArrayList<String> chunkedLines = new ArrayList<String>();
        for (String line : lines = text.split("\\n")) {
            chunkedLines.addAll(this.chunk(line, maxWidth));
        }
        return chunkedLines;
    }

    public List<String> chunk(String text, float maxWidth) {
        if (this.isBlank(text)) {
            return Collections.emptyList();
        }
        if (this.font.width(text) <= maxWidth) {
            return List.of(text);
        }
        List<String> tokens = this.tokenize(text.split("\\s"), maxWidth);
        return this.rechunk(tokens, maxWidth);
    }

    private List<String> rechunk(List<String> tokens, float maxWidth) {
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder currentLine = new StringBuilder();
        for (String word : tokens) {
            if (currentLine.isEmpty() || this.match(currentLine, word, maxWidth)) {
                currentLine.append(word).append(" ");
                continue;
            }
            lines.add(currentLine.toString().trim());
            currentLine = new StringBuilder(word).append(" ");
        }
        lines.add(currentLine.toString().trim());
        return lines;
    }

    private List<String> tokenize(String[] words, float maxWidth) {
        ArrayList<String> tokens = new ArrayList<String>();
        for (String word : words) {
            if (this.match(word, maxWidth)) {
                tokens.add(word);
                continue;
            }
            tokens.addAll(this.breakUp(word, maxWidth));
        }
        return tokens;
    }

    private boolean match(StringBuilder sb, String next, float maxWidth) {
        return this.match(sb.toString() + " " + next, maxWidth);
    }

    private boolean match(String token, float maxWidth) {
        return this.font.width(token) <= maxWidth;
    }

    private boolean isBlank(String text) {
        return text == null || text.trim().length() == 0;
    }

    private List<String> breakUp(String word, float maxWidth) {
        ArrayList<String> tokens = new ArrayList<String>();
        float fullWidth = this.font.width(word);
        int lineCharSize = Math.max(1, (int)Math.floor(maxWidth / fullWidth * (float)word.length()));
        for (int i = 0; i < word.length(); i += lineCharSize) {
            int endIndex = Math.min(word.length(), i + lineCharSize);
            tokens.add(word.substring(i, endIndex));
        }
        return tokens;
    }
}

