/*
 * Decompiled with CFR 0.152.
 */
package inspired.pdf.unbox.elements.internal;

import inspired.pdf.unbox.Bounds;
import inspired.pdf.unbox.Document;
import inspired.pdf.unbox.base.Column;
import inspired.pdf.unbox.base.ColumnModel;
import inspired.pdf.unbox.base.SimpleColumnModel;
import inspired.pdf.unbox.elements.Container;
import inspired.pdf.unbox.elements.PdfElement;
import inspired.pdf.unbox.elements.internal.ContainerLayout;
import java.util.List;

public class HorizontalLayout
implements ContainerLayout {
    protected final ColumnModel columnModel;

    public HorizontalLayout() {
        this.columnModel = null;
    }

    public HorizontalLayout(ColumnModel columnModel) {
        this.columnModel = columnModel;
    }

    @Override
    public float render(Document document, Bounds viewPort, Container container, List<PdfElement> elements) {
        Bounds bounds = viewPort.apply(container.margin()).apply(container.padding());
        float forward = 0.0f;
        ColumnModel<?> columns = this.columnModel(elements.size(), bounds);
        float offsetX = bounds.left();
        for (int i = 0; i < elements.size(); ++i) {
            PdfElement element = elements.get(i);
            Object column = columns.get(i);
            Bounds adjusted = bounds.width(((Column)column).width()).left(offsetX);
            forward = Math.max(element.render(document, adjusted), forward);
            offsetX += ((Column)column).width();
        }
        return forward + container.margin().vertical() + container.padding().vertical();
    }

    @Override
    public float innerHeight(Bounds viewPort, Container container, List<PdfElement> elements) {
        Bounds bounds = viewPort.apply(container.padding());
        ColumnModel<?> columns = this.columnModel(elements.size(), bounds);
        float maxHeight = 0.0f;
        for (int i = 0; i < elements.size(); ++i) {
            PdfElement element = elements.get(i);
            Object column = columns.get(i);
            Bounds adjusted = bounds.width(((Column)column).width());
            maxHeight = Math.max(element.innerHeight(adjusted), maxHeight);
        }
        return maxHeight + container.padding().vertical();
    }

    protected ColumnModel<?> columnModel(int columns, Bounds bounds) {
        if (this.columnModel == null) {
            return SimpleColumnModel.uniform(columns).scaleToSize(bounds.width());
        }
        if (this.columnModel.size() < columns) {
            throw new IllegalStateException("More elements than columns defined: " + columns);
        }
        return this.columnModel.scaleToSize(bounds.width());
    }

    @Override
    public Container.Layout layoutType() {
        return Container.Layout.COLUMNS;
    }
}

