/*
 * Decompiled with CFR 0.152.
 */
package inspired.pdf.unbox.elements;

import inspired.pdf.unbox.Bounds;
import inspired.pdf.unbox.Document;
import inspired.pdf.unbox.elements.internal.AbstractPdfElement;
import inspired.pdf.unbox.internal.PdfUnboxException;
import java.awt.Color;
import java.io.IOException;
import org.apache.pdfbox.pdmodel.PDPageContentStream;

public abstract class Canvas
extends AbstractPdfElement {
    private final float innerHeight;

    public Canvas(float innerhHeight) {
        this.innerHeight = innerhHeight;
    }

    public abstract void paint(PDPageContentStream var1, Bounds var2) throws IOException;

    protected void drawCircle(PDPageContentStream contentStream, float cx, float cy, float r, Color color) throws IOException {
        float k = 0.5522848f;
        contentStream.setNonStrokingColor(color);
        contentStream.moveTo(cx - r, cy);
        contentStream.curveTo(cx - r, cy + 0.5522848f * r, cx - 0.5522848f * r, cy + r, cx, cy + r);
        contentStream.curveTo(cx + 0.5522848f * r, cy + r, cx + r, cy + 0.5522848f * r, cx + r, cy);
        contentStream.curveTo(cx + r, cy - 0.5522848f * r, cx + 0.5522848f * r, cy - r, cx, cy - r);
        contentStream.curveTo(cx - 0.5522848f * r, cy - r, cx - r, cy - 0.5522848f * r, cx - r, cy);
        contentStream.fill();
    }

    @Override
    public float render(Document document, Bounds viewPort) {
        try {
            this.paint(document.getContentStream(), viewPort.height(this.innerHeight));
            return this.innerHeight + this.margin().vertical();
        }
        catch (IOException e) {
            throw new PdfUnboxException(e);
        }
    }

    @Override
    public float innerHeight(Bounds viewPort) {
        return this.innerHeight;
    }
}

