/*
 * Decompiled with CFR 0.152.
 */
package inspired.pdf.unbox.elements.internal;

import inspired.pdf.unbox.Bounds;
import inspired.pdf.unbox.Document;
import inspired.pdf.unbox.Padding;
import inspired.pdf.unbox.base.Column;
import inspired.pdf.unbox.base.ColumnModel;
import inspired.pdf.unbox.elements.Container;
import inspired.pdf.unbox.elements.PdfElement;
import inspired.pdf.unbox.elements.internal.HorizontalLayout;
import java.util.List;

public class HorizontalStretchLayout
extends HorizontalLayout {
    public HorizontalStretchLayout() {
        this(null);
    }

    public HorizontalStretchLayout(ColumnModel columnModel) {
        super(columnModel);
    }

    @Override
    public float render(Document document, Bounds viewPort, Container container, List<PdfElement> elements) {
        Bounds adjusted;
        Object column;
        PdfElement element;
        int i;
        Bounds bounds = viewPort.apply(container.margin()).apply(container.padding());
        float forward = 0.0f;
        ColumnModel<?> columns = this.columnModel(elements.size(), bounds);
        float offsetX = bounds.left();
        float maxInnerHeight = 0.0f;
        for (i = 0; i < elements.size(); ++i) {
            element = elements.get(i);
            column = columns.get(i);
            adjusted = bounds.width(((Column)column).width());
            maxInnerHeight = Math.max(maxInnerHeight, element.innerHeight(adjusted));
        }
        for (i = 0; i < elements.size(); ++i) {
            element = elements.get(i);
            column = columns.get(i);
            adjusted = bounds.width(((Column)column).width()).left(offsetX);
            element.renderingHints().addExtraPadding(Padding.bottom(maxInnerHeight - element.innerHeight(adjusted)));
            forward = Math.max(element.render(document, adjusted), forward);
            offsetX += ((Column)column).width();
        }
        return forward + container.margin().vertical() + container.padding().vertical();
    }

    @Override
    public boolean applyRenderingHintsToContainer() {
        return false;
    }
}

