/*
 * Decompiled with CFR 0.152.
 */
package inspired.pdf.unbox.elements;

import inspired.pdf.unbox.Align;
import inspired.pdf.unbox.Bounds;
import inspired.pdf.unbox.Document;
import inspired.pdf.unbox.Font;
import inspired.pdf.unbox.elements.internal.AbstractTableCell;
import inspired.pdf.unbox.internal.PdfUnboxException;
import inspired.pdf.unbox.internal.SimpleFont;
import inspired.pdf.unbox.internal.TextTokenizer;
import java.io.IOException;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDPageContentStream;

public class TextCell
extends AbstractTableCell {
    private static final int LINE_PADDING = 10;
    private final Font font;
    private String text;

    public TextCell(String text) {
        this(text, null);
    }

    public TextCell(String text, Font font) {
        this(text, Align.LEFT, font);
    }

    public TextCell(String text, Align align, Font font) {
        this.font = font != null ? font : SimpleFont.helvetica(8.0f);
        this.text = text != null ? text : "";
        this.align = align;
    }

    @Override
    public float innerHeight(Bounds viewPort) {
        float lineHeight = this.font.lineHeight();
        List<String> lines = this.chunk(viewPort.width() - this.padding.horizontal());
        int count = Math.max(1, lines.size());
        return (float)count * lineHeight + 10.0f;
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            value = "";
        }
        this.text = value.toString();
    }

    @Override
    protected float renderCell(Document document, Bounds bounds) {
        this.applyDecorators(document, bounds);
        try {
            float lineHeight = this.font.lineHeight();
            PDPageContentStream contentStream = document.getContentStream();
            List<String> lines = this.chunk(bounds.width() - this.padding.horizontal());
            float y = bounds.top() - lineHeight - this.padding.top();
            Align align = this.coalesce(this.align, Align.LEFT);
            for (String line : lines) {
                float startX = this.startX(bounds, align, line);
                contentStream.beginText();
                contentStream.setFont(this.font.getFont(), this.font.getSize());
                contentStream.setNonStrokingColor(this.font.getColor());
                contentStream.newLineAtOffset(startX, y);
                contentStream.showText(line);
                contentStream.endText();
                y -= lineHeight;
            }
            int count = Math.max(1, lines.size());
            return (float)count * lineHeight + 10.0f;
        }
        catch (IOException e) {
            throw new PdfUnboxException(e);
        }
    }

    private List<String> chunk(float maxWidth) {
        return new TextTokenizer(this.font).chunkMultiLine(this.text, maxWidth);
    }

    private float startX(Bounds bounds, Align align, String text) {
        if (text == null) {
            return bounds.left();
        }
        float textWidth = this.font.width(text);
        return switch (align) {
            default -> throw new IncompatibleClassChangeError();
            case Align.LEFT -> bounds.left() + this.padding.left();
            case Align.CENTER -> (int)(bounds.left() + this.padding.horizontalShift() + (bounds.width() - textWidth) / 2.0f);
            case Align.RIGHT -> (int)(bounds.left() + bounds.width() - this.padding.right() - textWidth);
        };
    }

    private Align coalesce(Align ... options) {
        for (Align option : options) {
            if (option == null) continue;
            return option;
        }
        return null;
    }
}

