/*
 * Decompiled with CFR 0.152.
 */
package inspired.pdf.unbox.elements;

import inspired.pdf.unbox.Bounds;
import inspired.pdf.unbox.Document;
import inspired.pdf.unbox.Margin;
import inspired.pdf.unbox.Padding;
import inspired.pdf.unbox.base.ColumnModel;
import inspired.pdf.unbox.decorators.Decorator;
import inspired.pdf.unbox.elements.PdfElement;
import inspired.pdf.unbox.elements.internal.AbstractPdfElement;
import inspired.pdf.unbox.elements.internal.ContainerLayout;
import inspired.pdf.unbox.elements.internal.HorizontalLayout;
import inspired.pdf.unbox.elements.internal.VerticalLayout;
import java.util.ArrayList;
import java.util.List;

public class Container
extends AbstractPdfElement {
    private final List<PdfElement> elements = new ArrayList<PdfElement>();
    private final List<Decorator> decorators = new ArrayList<Decorator>();
    private final ContainerLayout layout;

    public static Container withColumnLayout() {
        return new Container(Layout.COLUMNS);
    }

    public static Container withColumnLayout(ColumnModel<?> model) {
        return new Container(model);
    }

    public static Container withRowLayout() {
        return new Container(Layout.ROWS);
    }

    public Container(ContainerLayout layout) {
        this.layout = layout;
    }

    public Container(Layout layout) {
        this.layout = switch (layout) {
            default -> throw new IncompatibleClassChangeError();
            case Layout.COLUMNS -> new HorizontalLayout();
            case Layout.ROWS -> new VerticalLayout();
        };
    }

    public Container(ColumnModel<?> model) {
        this(new HorizontalLayout(model));
    }

    public Container add(PdfElement element) {
        this.elements.add(element);
        return this;
    }

    @Override
    public Container with(Margin margin) {
        super.with(margin);
        return this;
    }

    @Override
    public Container with(Padding padding) {
        super.with(padding);
        return this;
    }

    @Override
    public float render(Document document, Bounds viewPort) {
        this.applyDecorators(document, viewPort);
        return this.layout.render(document, viewPort, this, this.elements);
    }

    @Override
    public float innerHeight(Bounds viewPort) {
        return this.layout.innerHeight(viewPort, this, this.elements);
    }

    @Override
    public Container with(Decorator decorator) {
        this.decorators.add(decorator);
        return this;
    }

    public List<PdfElement> getElements() {
        return this.elements;
    }

    protected void applyDecorators(Document document, Bounds viewPort) {
        Bounds bounds = viewPort.height(this.outerHeight(viewPort) + (this.layout.applyRenderingHintsToContainer() ? this.renderingHints().getExtraPadding().vertical() : 0.0f)).apply(this.margin());
        for (Decorator decorator : this.decorators) {
            decorator.render(document, bounds);
        }
    }

    public String toString() {
        return "Container[" + String.valueOf((Object)this.layout.layoutType()) + "]{elements=" + String.valueOf(this.elements) + "}";
    }

    public static enum Layout {
        COLUMNS,
        ROWS;

    }
}

