/*
 * Decompiled with CFR 0.152.
 */
package inspired.pdf.unbox.decorators;

import inspired.pdf.unbox.Border;
import inspired.pdf.unbox.Bounds;
import inspired.pdf.unbox.Document;
import inspired.pdf.unbox.Position;
import inspired.pdf.unbox.decorators.Decorator;
import inspired.pdf.unbox.internal.PdfUnboxException;
import java.awt.Color;
import java.io.IOException;
import org.apache.pdfbox.pdmodel.PDPageContentStream;

public class BorderDecorator
extends Decorator {
    public static int LEVEL = 1000;
    private final Border border;
    private final Color color;

    public static BorderDecorator border(Border border, Color color) {
        return new BorderDecorator(border, color);
    }

    public static BorderDecorator border(float size, Color color) {
        return new BorderDecorator(Border.of(size), color);
    }

    public BorderDecorator(Border border) {
        this(border, Color.BLACK);
    }

    public BorderDecorator(Border border, Color color) {
        super(LEVEL);
        this.border = border;
        this.color = color;
    }

    @Override
    public float decorate(Document document, Bounds viewPort) {
        try {
            PDPageContentStream contentStream = document.getContentStream();
            contentStream.setStrokingColor(this.color);
            if (this.border.isUniform()) {
                contentStream.setLineWidth(this.border.top());
                this.renderRect(viewPort, contentStream);
            } else {
                this.renderLine(viewPort.topLeft(), viewPort.topRight(), contentStream, this.border.top());
                this.renderLine(viewPort.topLeft(), viewPort.bottomLeft(), contentStream, this.border.left());
                this.renderLine(viewPort.bottomLeft(), viewPort.bottomRight(), contentStream, this.border.bottom());
                this.renderLine(viewPort.bottomRight(), viewPort.topRight(), contentStream, this.border.right());
            }
            return 0.0f;
        }
        catch (IOException e) {
            throw new PdfUnboxException(e);
        }
    }

    private void renderLine(Position start, Position end, PDPageContentStream contentStream, float lineWidth) throws IOException {
        if (lineWidth > 0.0f) {
            contentStream.setLineWidth(lineWidth);
            contentStream.moveTo(start.x(), start.y());
            contentStream.lineTo(end.x(), end.y());
            contentStream.stroke();
        }
    }

    private void renderRect(Bounds viewPort, PDPageContentStream contentStream) throws IOException {
        contentStream.addRect(viewPort.left(), viewPort.bottom(), viewPort.width(), viewPort.height());
        contentStream.stroke();
    }
}

