/*
 * Decompiled with CFR 0.152.
 */
package inspired.pdf.unbox.elements.internal;

import inspired.pdf.unbox.Bounds;
import inspired.pdf.unbox.Document;
import inspired.pdf.unbox.Margin;
import inspired.pdf.unbox.Position;
import inspired.pdf.unbox.Stroke;
import inspired.pdf.unbox.base.Column;
import inspired.pdf.unbox.base.ColumnModel;
import inspired.pdf.unbox.decorators.Decorator;
import inspired.pdf.unbox.elements.Table;
import inspired.pdf.unbox.elements.TableRow;
import inspired.pdf.unbox.elements.internal.AbstractDecoratable;
import inspired.pdf.unbox.internal.PdfUnboxException;
import inspired.pdf.unbox.themes.UnboxTheme;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDPageContentStream;

public abstract class AbstractTable
extends AbstractDecoratable
implements Table {
    private final List<TableRow> headers = new ArrayList<TableRow>();
    private final List<TableRow> rows = new ArrayList<TableRow>();
    private Margin margin = Margin.of(0.0f);
    private boolean repeatHeader = true;
    private float tableStartOnPage;
    private Stroke stroke = new Stroke(UnboxTheme.GRAY_700, 0.4f);

    @Override
    public TableRow addRow() {
        return this.addRow(new TableRow());
    }

    @Override
    public TableRow addRow(TableRow row) {
        this.rows.add(row);
        return row;
    }

    @Override
    public TableRow addHeader(TableRow row) {
        this.headers.add(row);
        return row;
    }

    @Override
    public TableRow addRow(Object ... values) {
        TableRow row = this.addRow();
        row.withValues(values);
        return row;
    }

    @Override
    public Table with(Decorator decorator) {
        super.with(decorator);
        return this;
    }

    @Override
    public Table with(Margin margin) {
        this.margin = margin;
        return this;
    }

    @Override
    public Table with(Stroke stroke) {
        this.stroke = stroke;
        return this;
    }

    @Override
    public float innerHeight(Bounds viewPort) {
        return 0.0f;
    }

    @Override
    public Margin margin() {
        return this.margin;
    }

    public Table repeatHeader(boolean repeat) {
        this.repeatHeader = repeat;
        return this;
    }

    @Override
    public float render(Document document, Bounds viewPort) {
        try {
            document.forward(this.margin.top());
            this.tableStartOnPage = document.getPosition();
            this.renderRows(document, this.headers);
            this.renderRows(document, this.rows);
            this.applyDecorators(document);
            return this.margin.bottom();
        }
        catch (IOException e) {
            throw new PdfUnboxException(e);
        }
    }

    protected void onBeforeNewPage(Document document) {
    }

    protected void onAfterNewPage(Document document) {
    }

    protected Margin getMargin() {
        return this.margin;
    }

    protected float renderRow(Document document, TableRow row) {
        float rowHeight = row.innerHeight(this.effectiveViewport(document));
        this.checkPageBreak(document, rowHeight);
        Bounds bounds = this.effectiveViewport(document).height(rowHeight);
        row.render(document, bounds);
        this.drawRowLines(document, rowHeight);
        return rowHeight;
    }

    public float getTableStartOnPage() {
        return this.tableStartOnPage;
    }

    private float renderRows(Document document, Iterable<TableRow> rows) throws IOException {
        float height = 0.0f;
        for (TableRow row : rows) {
            float rowHeight = this.renderRow(document, row);
            document.forward(rowHeight);
            height += rowHeight;
        }
        return height;
    }

    private void drawRowLines(Document document, float rowHeight) {
        if (this.stroke.isEmpty()) {
            return;
        }
        try {
            PDPageContentStream contentStream = document.getContentStream();
            contentStream.setLineWidth(this.stroke.width());
            contentStream.setStrokingColor(this.stroke.color());
            Bounds bounds = document.getCurrentViewPort().apply(this.horizontalMargin()).height(rowHeight);
            contentStream.moveTo(bounds.left(), bounds.top());
            contentStream.lineTo(bounds.right(), bounds.top());
            contentStream.stroke();
            contentStream.moveTo(bounds.left(), bounds.bottom());
            contentStream.lineTo(bounds.right(), bounds.bottom());
            contentStream.stroke();
        }
        catch (IOException e) {
            throw new PdfUnboxException(e);
        }
    }

    protected void drawColumnLines(Document document, ColumnModel<?> columns, Bounds bounds) {
        if (this.stroke.isEmpty()) {
            return;
        }
        try {
            PDPageContentStream contentStream = document.getContentStream();
            contentStream.setLineWidth(this.stroke.width());
            contentStream.setStrokingColor(this.stroke.color());
            boolean first = true;
            for (Column col : columns) {
                if (first) {
                    first = false;
                } else {
                    this.drawLine(contentStream, bounds.topLeft(), bounds.bottomLeft());
                }
                bounds = bounds.moveRight(col.width());
            }
        }
        catch (IOException e) {
            throw new PdfUnboxException(e);
        }
    }

    protected Bounds effectiveViewport(Document document) {
        return document.getCurrentViewPort().apply(this.horizontalMargin());
    }

    protected Margin horizontalMargin() {
        return Margin.of(0.0f, this.margin.right(), 0.0f, this.margin.left());
    }

    private void drawLine(PDPageContentStream contentStream, Position start, Position end) {
        try {
            contentStream.moveTo(start.x(), start.y());
            contentStream.lineTo(end.x(), end.y());
            contentStream.stroke();
        }
        catch (IOException e) {
            throw new PdfUnboxException(e);
        }
    }

    private void checkPageBreak(Document document, float minSpace) {
        try {
            if (document.getSpaceLeftOnPage() < minSpace) {
                this.applyDecorators(document);
                this.onBeforeNewPage(document);
                document.addPage();
                this.tableStartOnPage = document.getPosition();
                this.onAfterNewPage(document);
                if (this.repeatHeader) {
                    this.renderRows(document, this.headers);
                }
            }
        }
        catch (IOException e) {
            throw new PdfUnboxException(e);
        }
    }

    private void applyDecorators(Document document) throws IOException {
        float height = this.tableStartOnPage - document.getPosition();
        Bounds bounds = document.getViewPort().apply(this.horizontalMargin()).top(this.tableStartOnPage).height(height);
        super.applyDecorators(document, bounds);
    }
}

