/*
 * Decompiled with CFR 0.152.
 */
package inspired.pdf.unbox.elements;

import inspired.pdf.unbox.Bounds;
import inspired.pdf.unbox.Document;
import inspired.pdf.unbox.Font;
import inspired.pdf.unbox.base.ColumnModel;
import inspired.pdf.unbox.base.TableModel;
import inspired.pdf.unbox.decorators.Decorator;
import inspired.pdf.unbox.elements.TableRow;
import inspired.pdf.unbox.elements.internal.AbstractTable;

public class FlexTable
extends AbstractTable {
    public FlexTable withHeader(TableModel model, Font font, Decorator ... decorators) {
        this.addHeader(TableRow.header(model, font, decorators));
        return this;
    }

    @Override
    protected float renderRow(Document document, TableRow row) {
        float rowHeight = super.renderRow(document, row);
        Object columns = row.columnModel().scaleToSize(document.getViewPort().width());
        this.drawColumnLines(document, (ColumnModel<?>)columns, rowHeight);
        return rowHeight;
    }

    private void drawColumnLines(Document document, ColumnModel<?> columns, float height) {
        Bounds viewPort = document.getViewPort();
        Bounds bounds = new Bounds(viewPort.left(), document.getPosition(), viewPort.width(), height);
        this.drawColumnLines(document, columns, bounds);
    }
}

