/*
 * Decompiled with CFR 0.152.
 */
package inspired.pdf.unbox.decorators;

import inspired.pdf.unbox.Bounds;
import inspired.pdf.unbox.Document;
import inspired.pdf.unbox.Margin;
import inspired.pdf.unbox.elements.PdfElement;
import inspired.pdf.unbox.elements.internal.RenderingHints;

public abstract class Decorator
implements PdfElement {
    private PdfElement wrappedElement = null;
    private RenderingHints renderingHints = new RenderingHints();

    public static Decorator pass() {
        return new VoidDecorator();
    }

    public PdfElement wrap(PdfElement element) {
        this.wrappedElement = element;
        return this;
    }

    public abstract float decorate(Document var1, Bounds var2);

    @Override
    public final float render(Document document, Bounds viewPort) {
        if (this.wrappedElement != null) {
            float height = this.wrappedElement.innerHeight(viewPort);
            this.decorate(document, viewPort.apply(this.wrappedElement.margin()).height(height));
            return this.wrappedElement.render(document, viewPort);
        }
        return this.decorate(document, viewPort);
    }

    @Override
    public Margin margin() {
        if (this.wrappedElement != null) {
            return this.wrappedElement.margin();
        }
        return Margin.none();
    }

    @Override
    public float innerHeight(Bounds viewPort) {
        if (this.wrappedElement != null) {
            return this.wrappedElement.innerHeight(viewPort);
        }
        return 0.0f;
    }

    @Override
    public RenderingHints renderingHints() {
        return this.renderingHints;
    }

    private static class VoidDecorator
    extends Decorator {
        private VoidDecorator() {
        }

        @Override
        public float decorate(Document document, Bounds viewPort) {
            return 0.0f;
        }
    }
}

