/*
 * Decompiled with CFR 0.152.
 */
package inspired.pdf.unbox;

import inspired.pdf.unbox.Bounds;
import inspired.pdf.unbox.DocumentContext;
import inspired.pdf.unbox.Margin;
import inspired.pdf.unbox.Orientation;
import inspired.pdf.unbox.Padding;
import inspired.pdf.unbox.Position;
import inspired.pdf.unbox.elements.PdfElement;
import inspired.pdf.unbox.internal.PdfEventListener;
import inspired.pdf.unbox.internal.PdfUnboxException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;

public class Document
implements DocumentContext {
    private final Orientation orientation;
    private final Margin margin;
    private final Padding padding;
    private final PDDocument document;
    private PDPage page;
    private PDPageContentStream contentStream;
    private final List<PdfEventListener> eventListeners = new ArrayList<PdfEventListener>();
    private Position position = new Position(0.0f, 0.0f);

    public Document() {
        this(Orientation.PORTRAIT);
    }

    public Document(Orientation orientation) {
        this(orientation, Margin.of(20.0f), Padding.of(30.0f, 0.0f, 20.0f));
    }

    public Document(Orientation orientation, Margin margin, Padding padding) {
        this.document = new PDDocument();
        this.orientation = orientation;
        this.margin = margin;
        this.padding = padding;
    }

    public Document add(PdfEventListener listener) {
        this.eventListeners.add(listener);
        return this;
    }

    public float getPosition() {
        this.getPage();
        return this.position.y();
    }

    public float getPositionY() {
        this.getPage();
        return this.position.y();
    }

    public void setPosition(Position position) {
        this.position = position;
    }

    @Override
    public Margin getMargin() {
        return this.margin;
    }

    @Override
    public Padding getPadding() {
        return this.padding;
    }

    @Override
    public Bounds getPageBounds() {
        PDRectangle mediaBox = this.getPage().getMediaBox();
        return new Bounds(0.0f, mediaBox.getHeight(), mediaBox.getWidth(), mediaBox.getHeight());
    }

    @Override
    public Bounds getViewPort() {
        return this.getContentBounds().apply(this.padding);
    }

    public Bounds getCurrentViewPort() {
        return this.getViewPort().top(this.position.y()).height(this.getSpaceLeftOnPage());
    }

    @Override
    public Bounds getHeaderBounds() {
        float headerHeight = this.padding.top();
        return this.getContentBounds().height(headerHeight);
    }

    @Override
    public Bounds getFooterBounds() {
        float footerHeight = this.padding.bottom();
        Bounds contentBounds = this.getContentBounds();
        return new Bounds(contentBounds.left(), contentBounds.bottom() + footerHeight, contentBounds.width(), footerHeight);
    }

    public float getSpaceLeftOnPage() {
        return this.position.y() - this.margin.bottom() - this.padding.bottom();
    }

    public void render(PdfElement element) {
        float height = element.innerHeight(this.getCurrentViewPort());
        this.forwardPageIfNeeded(height);
        float forward = element.render(this, this.getCurrentViewPort());
        this.forward(forward);
    }

    public void forward(float amount) {
        this.getPage();
        this.position = this.position.moveDown(amount);
    }

    public PDPage addPage() {
        return this.addPage(this.orientation);
    }

    public PDPage addPage(Orientation orientation) {
        this.closeContentStream();
        PDRectangle rectangle = PDRectangle.A4;
        this.page = Orientation.LANDSCAPE.equals((Object)orientation) ? new PDPage(new PDRectangle(rectangle.getHeight(), rectangle.getWidth())) : new PDPage(new PDRectangle(rectangle.getWidth(), rectangle.getHeight()));
        this.document.addPage(this.page);
        float offsetY = this.page.getMediaBox().getHeight() - this.margin.top() - this.padding.top();
        this.position = new Position(this.position.x(), offsetY);
        this.onNewPage(this.page);
        return this.page;
    }

    public void forwardPageIfNeeded(float spaceNeeded) {
        if (this.getSpaceLeftOnPage() < spaceNeeded) {
            this.addPage();
        }
    }

    public PDDocument finish() {
        this.getPage();
        this.closeContentStream();
        this.onFinish();
        return this.document;
    }

    public PDPageContentStream getContentStream() {
        if (this.contentStream == null) {
            try {
                this.contentStream = new PDPageContentStream(this.document, this.getPage());
            }
            catch (IOException e) {
                throw new PdfUnboxException(e);
            }
        }
        return this.contentStream;
    }

    public PDPage getPage() {
        if (this.page == null) {
            this.addPage();
        }
        return this.page;
    }

    public PDDocument getDocument() {
        return this.document;
    }

    protected void onNewPage(PDPage page) {
        for (PdfEventListener listener : this.eventListeners) {
            listener.onNewPage(this);
        }
    }

    protected void onFinish() {
        for (PdfEventListener listener : this.eventListeners) {
            listener.onFinished(this);
        }
    }

    private void closeContentStream() {
        if (this.contentStream != null) {
            try {
                this.contentStream.close();
            }
            catch (IOException e) {
                throw new PdfUnboxException(e);
            }
            this.contentStream = null;
        }
    }
}

