/*
 * Decompiled with CFR 0.152.
 */
package inspired.pdf.unbox.internal;

import inspired.pdf.unbox.Align;
import inspired.pdf.unbox.Bounds;
import inspired.pdf.unbox.Font;
import inspired.pdf.unbox.VAlign;
import inspired.pdf.unbox.internal.PdfUnboxException;
import inspired.pdf.unbox.internal.TextTokenizer;
import java.io.IOException;
import org.apache.pdfbox.pdmodel.PDPageContentStream;

public class TextWriter {
    public static final float CORRECTION_FACTOR = 0.25f;
    private final Font font;

    public TextWriter(Font font) {
        this.font = font;
    }

    public float calculateHeight(String text, Bounds viewPort) {
        String[] lines = this.chunk(text, viewPort.width());
        int count = Math.max(1, lines.length);
        return (float)count * this.font.lineHeight();
    }

    public float write(PDPageContentStream contentStream, Bounds bounds, String text) {
        return this.write(contentStream, bounds, text, Align.LEFT);
    }

    public float write(PDPageContentStream stream, Bounds bounds, String text, Align align) {
        float y = bounds.top() - this.font.lineHeight();
        return this.write(text, bounds, align, stream, y);
    }

    public float write(PDPageContentStream stream, Bounds bounds, String text, Align align, VAlign vAlign) {
        float y = this.offsetY(bounds, vAlign);
        return this.write(text, bounds, align, stream, y);
    }

    private float write(String text, Bounds bounds, Align align, PDPageContentStream stream, float y) {
        String[] chunks;
        for (String chunk : chunks = this.chunk(text, bounds.width())) {
            float x = this.offsetX(bounds, chunk, align);
            this.writeLine(stream, chunk, x, y);
            y -= this.font.lineHeight();
        }
        int count = Math.max(1, chunks.length);
        return (float)count * this.font.lineHeight();
    }

    private String[] chunk(String text, float maxWidth) {
        return new TextTokenizer(this.font).chunk(text, maxWidth);
    }

    private void writeLine(PDPageContentStream contentStream, String text, float x, float y) {
        try {
            contentStream.beginText();
            contentStream.setNonStrokingColor(this.font.getColor());
            contentStream.setFont(this.font.getFont(), this.font.getSize());
            contentStream.newLineAtOffset(x, y);
            contentStream.showText(text);
            contentStream.endText();
        }
        catch (IOException e) {
            throw new PdfUnboxException(e);
        }
    }

    private float offsetX(Bounds bounds, String text, Align align) {
        float textWidth = this.font.width(text);
        return switch (align) {
            default -> throw new IncompatibleClassChangeError();
            case Align.LEFT -> bounds.left();
            case Align.CENTER -> (int)(bounds.center() - textWidth / 2.0f);
            case Align.RIGHT -> (int)(bounds.left() + bounds.width() - textWidth);
        };
    }

    private float offsetY(Bounds bounds, VAlign vAlign) {
        float correction = this.font.lineHeight() * 0.25f;
        return switch (vAlign) {
            default -> throw new IncompatibleClassChangeError();
            case VAlign.TOP -> bounds.top() - this.font.lineHeight() + correction;
            case VAlign.MIDDLE -> bounds.middle() - this.font.lineHeight() / 2.0f + correction / 2.0f;
            case VAlign.BOTTOM -> bounds.bottom() + correction;
        };
    }
}

