/*
 * Decompiled with CFR 0.152.
 */
package inspired.pdf.unbox.elements.internal;

import inspired.pdf.unbox.Bounds;
import inspired.pdf.unbox.Document;
import inspired.pdf.unbox.Margin;
import inspired.pdf.unbox.Padding;
import inspired.pdf.unbox.elements.PdfElement;

public abstract class AbstractPdfElement
implements PdfElement {
    private Margin margin = Margin.none();
    private Padding padding = Padding.none();

    public static PdfElement empty() {
        return new EmptyElement();
    }

    public AbstractPdfElement with(Margin margin) {
        this.margin = margin;
        return this;
    }

    public AbstractPdfElement with(Padding padding) {
        this.padding = padding;
        return this;
    }

    @Override
    public Margin margin() {
        return this.margin;
    }

    public Padding padding() {
        return this.padding;
    }

    private static class EmptyElement
    extends AbstractPdfElement {
        private EmptyElement() {
        }

        @Override
        public float render(Document document, Bounds viewPort) {
            return 0.0f;
        }

        @Override
        public float innerHeight(Bounds viewPort) {
            return 0.0f;
        }
    }
}

