/*
 * Decompiled with CFR 0.152.
 */
package inspired.pdf.unbox.elements;

import inspired.pdf.unbox.Bounds;
import inspired.pdf.unbox.Document;
import inspired.pdf.unbox.base.ColumnModel;
import inspired.pdf.unbox.base.TableModel;
import inspired.pdf.unbox.elements.TableRow;
import inspired.pdf.unbox.elements.internal.AbstractTable;

public class FixedColumnsTable
extends AbstractTable {
    private final TableModel model;

    public FixedColumnsTable(TableModel model) {
        this.model = model;
    }

    public TableModel getModel() {
        return this.model;
    }

    public FixedColumnsTable withHeader() {
        this.addRow(TableRow.header(this.model));
        return this;
    }

    @Override
    public TableRow addRow() {
        return this.addRow(new TableRow(this.model));
    }

    @Override
    protected float renderRow(Document document, TableRow row) {
        float rowHeight = super.renderRow(document, row);
        TableModel columns = this.model.scaleToSize(document.getViewPort().width());
        this.drawColumnLines(document, columns, rowHeight);
        return rowHeight;
    }

    private void drawColumnLines(Document document, ColumnModel<?> columns, float height) {
        Bounds viewPort = document.getViewPort();
        Bounds bounds = new Bounds(viewPort.left(), document.getPosition(), viewPort.width(), height);
        this.drawColumnLines(document, columns, bounds);
    }
}

