/*
 * Decompiled with CFR 0.152.
 */
package inspired.pdf.unbox.decorators;

import inspired.pdf.unbox.Bounds;
import inspired.pdf.unbox.Document;
import inspired.pdf.unbox.decorators.Decorator;
import inspired.pdf.unbox.internal.PdfUnboxException;
import java.awt.Color;
import java.io.IOException;
import org.apache.pdfbox.pdmodel.PDPageContentStream;

public class BackgroundDecorator
extends Decorator {
    private final Color color;

    public BackgroundDecorator(Color color) {
        this.color = color;
    }

    @Override
    public float decorate(Document document, Bounds viewPort) {
        try {
            PDPageContentStream contentStream = document.getContentStream();
            contentStream.setNonStrokingColor(this.color);
            contentStream.addRect(viewPort.left(), viewPort.bottom(), viewPort.width(), viewPort.height());
            contentStream.fill();
            return 0.0f;
        }
        catch (IOException e) {
            throw new PdfUnboxException(e);
        }
    }
}

