/*
 * Decompiled with CFR 0.152.
 */
package inspired.pdf.unbox;

import inspired.pdf.unbox.Document;
import inspired.pdf.unbox.DocumentContext;
import inspired.pdf.unbox.internal.PdfEventListener;
import inspired.pdf.unbox.internal.PdfUnboxException;
import java.io.IOException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.PDPageTree;

public abstract class DocumentFinisher
implements PdfEventListener {
    public abstract void finish(DocumentContext var1, PDPageContentStream var2, int var3, int var4);

    protected void finish(Document document, PDDocument pdf, PDPageTree allPages) throws IOException {
        int pageNum = 1;
        for (PDPage page : allPages) {
            PDPageContentStream contentStream = new PDPageContentStream(pdf, page, PDPageContentStream.AppendMode.APPEND, true, true);
            this.finish(document, contentStream, pageNum, allPages.getCount());
            contentStream.close();
            ++pageNum;
        }
    }

    @Override
    public void onFinished(Document document) {
        PDDocument pdf = document.getDocument();
        PDPageTree allPages = pdf.getDocumentCatalog().getPages();
        try {
            this.finish(document, pdf, allPages);
        }
        catch (IOException e) {
            throw new PdfUnboxException(e);
        }
    }
}

