/*
 * Decompiled with CFR 0.152.
 */
package inspired.pdf.unbox;

import inspired.pdf.unbox.Margin;
import inspired.pdf.unbox.Padding;
import inspired.pdf.unbox.Position;
import java.util.Arrays;

public record Bounds(float left, float top, float width, float height) {
    public static Bounds join(Bounds ... bounds) {
        float left = Arrays.stream(bounds).map(Bounds::left).min(Float::compareTo).orElse(Float.valueOf(0.0f)).floatValue();
        float top = Arrays.stream(bounds).map(Bounds::top).max(Float::compareTo).orElse(Float.valueOf(0.0f)).floatValue();
        float right = Arrays.stream(bounds).map(Bounds::right).max(Float::compareTo).orElse(Float.valueOf(0.0f)).floatValue();
        float bottom = Arrays.stream(bounds).map(Bounds::bottom).min(Float::compareTo).orElse(Float.valueOf(0.0f)).floatValue();
        return new Bounds(left, top, right - left, top - bottom);
    }

    public float bottom() {
        return this.top - this.height;
    }

    public float center() {
        return this.left + this.width / 2.0f;
    }

    public float right() {
        return this.left + this.width;
    }

    public float middle() {
        return this.top - this.height / 2.0f;
    }

    public Position topLeft() {
        return new Position(this.left, this.top);
    }

    public Position topRight() {
        return new Position(this.right(), this.top);
    }

    public Position bottomLeft() {
        return new Position(this.left, this.bottom());
    }

    public Position bottomRight() {
        return new Position(this.right(), this.bottom());
    }

    public Bounds moveRight(float amount) {
        return new Bounds(this.left + amount, this.top, this.width, this.height);
    }

    public Bounds moveDown(float amount) {
        return new Bounds(this.left, this.top - amount, this.width, this.height);
    }

    public Bounds apply(Margin margin) {
        return new Bounds(this.left + margin.left(), this.top - margin.top(), this.width - margin.horizontal(), this.height - margin.vertical());
    }

    public Bounds apply(Padding padding) {
        return new Bounds(this.left + padding.left(), this.top - padding.top(), this.width - padding.horizontal(), this.height - padding.vertical());
    }

    public Bounds top(float top) {
        return new Bounds(this.left, top, this.width, this.height);
    }

    public Bounds left(float left) {
        return new Bounds(left, this.top, this.width, this.height);
    }

    public Bounds height(float height) {
        return new Bounds(this.left, this.top, this.width, height);
    }

    public Bounds width(float width) {
        return new Bounds(this.left, this.top, width, this.height);
    }

    public Bounds extend(Bounds bounds) {
        float left = Math.min(this.left, bounds.left);
        float top = Math.max(this.top, bounds.top);
        float right = Math.max(this.right(), bounds.right());
        float bottom = Math.min(this.bottom(), bounds.bottom());
        return new Bounds(left, top, right - left, top - bottom);
    }
}

