/*
 * Decompiled with CFR 0.152.
 */
package inspired.pdf.unbox.elements;

import inspired.pdf.unbox.Align;
import inspired.pdf.unbox.Bounds;
import inspired.pdf.unbox.Document;
import inspired.pdf.unbox.Font;
import inspired.pdf.unbox.base.ColumnModel;
import inspired.pdf.unbox.base.TableModel;
import inspired.pdf.unbox.decorators.Decorator;
import inspired.pdf.unbox.elements.PdfElement;
import inspired.pdf.unbox.elements.TableCell;
import inspired.pdf.unbox.elements.TextCell;
import inspired.pdf.unbox.elements.internal.AbstractDecoratable;
import inspired.pdf.unbox.internal.SimpleFont;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public class TableRow
extends AbstractDecoratable
implements PdfElement {
    private final List<Object> values = new ArrayList<Object>();
    private final List<TableCell> cells = new ArrayList<TableCell>();
    private final TableModel model;
    private final Font font;

    public static TableRow header(TableModel columns) {
        TableRow row = new TableRow(columns);
        for (TableModel.TableColumn column : columns) {
            row.addCell(column.title(), column.align());
        }
        return row;
    }

    public static TableRow header(TableModel columns, Font font) {
        TableRow row = new TableRow(columns, font);
        for (TableModel.TableColumn column : columns) {
            row.addCell(column.title(), column.align());
        }
        return row;
    }

    public TableRow() {
        this(new TableModel());
    }

    public TableRow(TableModel columns) {
        this(columns, null);
    }

    public TableRow(TableModel columns, Font font) {
        this.model = columns;
        this.font = font;
    }

    public int size() {
        return Math.max(this.cells.size(), this.values.size());
    }

    public ColumnModel<?> columnModel() {
        return this.model;
    }

    public TableRow addCell(String text) {
        return this.addCell(text, null);
    }

    public TableRow addCell(String text, Align align) {
        return this.addCell(text, align, null);
    }

    public TableRow addCell(String text, Align align, Font font) {
        if (this.model.size() >= this.cells.size()) {
            TableModel.TableColumn column = this.model.get(this.cells.size());
            Align effectiveAlign = this.coalesce(align, column.align());
            Font effectiveFont = this.coalesce(font, column.font(), this.font);
            return this.addCell(new TextCell(text, effectiveAlign, effectiveFont));
        }
        Align effectiveAlign = this.coalesce(align);
        Font effectiveFont = this.coalesce(font, this.font);
        return this.addCell(new TextCell(text, effectiveAlign, effectiveFont));
    }

    public <T extends TableCell> TableRow addCell(T cell) {
        this.cells.add(cell);
        if (this.model.size() < this.cells.size()) {
            this.model.add(TableModel.DEFAULT_COLUMN);
        }
        return this;
    }

    public TableRow withCells(String ... contents) {
        for (String text : contents) {
            this.addCell(text);
        }
        return this;
    }

    public TableRow withValues(Object ... values) {
        this.values.clear();
        this.values.addAll(Arrays.asList(values));
        return this;
    }

    @Override
    public TableRow with(Decorator decorator) {
        super.with(decorator);
        return this;
    }

    @Override
    public float render(Document document, Bounds bounds) {
        this.applyDecorators(document, bounds);
        float x = bounds.left();
        TableModel columns = this.model.scaleToSize(bounds.width());
        float maxHeight = 0.0f;
        for (int i = 0; i < this.size(); ++i) {
            TableCell cell = this.prepareCell(i);
            float width = columns.width(i);
            Bounds cellBounds = bounds.left(x).width(width);
            float height = cell.render(document, cellBounds);
            maxHeight = Math.max(maxHeight, height);
            x += width;
        }
        return maxHeight;
    }

    private TableCell prepareCell(int i) {
        if (i >= 0 && i < this.cells.size() && this.cells.get(i) != null) {
            return this.cells.get(i);
        }
        TableCell cell = this.model.get(i).cell();
        Object value = this.getValue(i);
        if (cell == null) {
            cell = this.model.getDefaultCellFor(value);
        }
        cell.setValue(value);
        return cell;
    }

    private Object getValue(int index) {
        if (index >= 0 && index < this.values.size()) {
            return this.values.get(index);
        }
        return null;
    }

    @Override
    public float innerHeight(Bounds viewPort) {
        TableModel columns = this.model.scaleToSize(viewPort.width());
        float max = 0.0f;
        for (int i = 0; i < this.size(); ++i) {
            TableCell cell = this.prepareCell(i);
            float width = columns.width(i);
            max = Math.max(max, cell.innerHeight(viewPort.width(width)));
        }
        return max;
    }

    private Align coalesce(Align ... options) {
        return Stream.of(options).filter(Objects::nonNull).findFirst().orElse(Align.LEFT);
    }

    private Font coalesce(Font ... options) {
        return Stream.of(options).filter(Objects::nonNull).findFirst().orElse(SimpleFont.helvetica(8.0f));
    }
}

