/*
 * Decompiled with CFR 0.152.
 */
package inspired.pdf.unbox.elements;

import inspired.pdf.unbox.Bounds;
import inspired.pdf.unbox.Document;
import inspired.pdf.unbox.Margin;
import inspired.pdf.unbox.Padding;
import inspired.pdf.unbox.elements.PdfElement;
import inspired.pdf.unbox.elements.internal.AbstractPdfElement;
import inspired.pdf.unbox.elements.internal.ContainerLayout;
import inspired.pdf.unbox.elements.internal.HorizontalLayout;
import inspired.pdf.unbox.elements.internal.VerticalLayout;
import java.util.ArrayList;
import java.util.List;

public class Container
extends AbstractPdfElement {
    private final List<PdfElement> elements = new ArrayList<PdfElement>();
    private final ContainerLayout layout;

    public static Container withColumnLayout() {
        return new Container(Layout.COLUMNS);
    }

    public static Container withRowLayout() {
        return new Container(Layout.ROWS);
    }

    public Container(Layout layout) {
        this.layout = switch (layout) {
            default -> throw new IncompatibleClassChangeError();
            case Layout.COLUMNS -> new HorizontalLayout();
            case Layout.ROWS -> new VerticalLayout();
        };
    }

    public Container add(PdfElement element) {
        this.elements.add(element);
        return this;
    }

    @Override
    public Container with(Margin margin) {
        super.with(margin);
        return this;
    }

    @Override
    public Container with(Padding padding) {
        super.with(padding);
        return this;
    }

    @Override
    public float render(Document document, Bounds viewPort) {
        return this.layout.render(document, viewPort, this, this.elements);
    }

    @Override
    public float innerHeight(Bounds viewPort) {
        return this.layout.innerHeight(viewPort, this, this.elements);
    }

    public static enum Layout {
        COLUMNS,
        ROWS;

    }
}

