/*
 * Decompiled with CFR 0.152.
 */
package inspired.pdf.unbox.base;

import inspired.pdf.unbox.Bounds;
import inspired.pdf.unbox.base.Column;
import inspired.pdf.unbox.base.ColumnModel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SimpleColumnModel
implements ColumnModel<Column> {
    private final List<Column> columns = new ArrayList<Column>();

    public SimpleColumnModel() {
    }

    public SimpleColumnModel(List<Column> columns) {
        this.columns.addAll(columns);
    }

    public static SimpleColumnModel uniform(int numColumns) {
        SimpleColumnModel model = new SimpleColumnModel();
        for (int i = 0; i < numColumns; ++i) {
            model.add(1.0f);
        }
        return model;
    }

    public static SimpleColumnModel of(Integer[] sizes) {
        return new SimpleColumnModel(Stream.of(sizes).map(Column::new).toList());
    }

    public static SimpleColumnModel of(Float[] sizes) {
        return new SimpleColumnModel(Stream.of(sizes).map(Column::new).toList());
    }

    public static SimpleColumnModel of(float ... width) {
        ArrayList<Column> columns = new ArrayList<Column>();
        for (float w : width) {
            columns.add(new Column(w));
        }
        return new SimpleColumnModel(columns);
    }

    public SimpleColumnModel add(Column column) {
        this.columns.add(column);
        return this;
    }

    public SimpleColumnModel add(float width) {
        return this.add(new Column(width));
    }

    public SimpleColumnModel append(SimpleColumnModel other) {
        this.columns.addAll(other.columns);
        return this;
    }

    @Override
    public int size() {
        return this.columns.size();
    }

    @Override
    public Column get(int index) {
        return this.columns.get(index);
    }

    @Override
    public float getOverallWidth() {
        return this.columns.stream().map(Column::width).reduce(Float::sum).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public SimpleColumnModel scale(float scale) {
        List<Column> adapted = this.columns.stream().map(c -> c.scale(scale)).collect(Collectors.toList());
        return new SimpleColumnModel(adapted);
    }

    @Override
    public SimpleColumnModel scaleToSize(float width) {
        return this.scale(width / this.getOverallWidth());
    }

    public List<Bounds> toBounds(Bounds viewPort) {
        ArrayList<Bounds> bounds = new ArrayList<Bounds>();
        float offset = viewPort.left();
        for (Column colum : this.columns) {
            bounds.add(new Bounds(offset, viewPort.top(), colum.width(), viewPort.height()));
            offset += colum.width();
        }
        return bounds;
    }

    @Override
    public Iterator<Column> iterator() {
        return this.columns.iterator();
    }
}

