/*
 * Decompiled with CFR 0.152.
 */
package inspired.pdf.unbox.internal;

import inspired.pdf.unbox.Font;
import java.util.ArrayList;
import java.util.Arrays;

public class TextTokenizer {
    private final Font font;

    public TextTokenizer(Font font) {
        this.font = font;
    }

    public String[] chunkMultiLine(String text, float maxWidth) {
        String[] lines;
        ArrayList<String> chunkedLines = new ArrayList<String>();
        for (String line : lines = text.split("\\n")) {
            chunkedLines.addAll(Arrays.asList(this.chunk(line, maxWidth)));
        }
        return chunkedLines.toArray(new String[chunkedLines.size()]);
    }

    public String[] chunk(String text, float maxWidth) {
        if (this.isBlank(text)) {
            return new String[0];
        }
        if (this.font.width(text) <= maxWidth) {
            return new String[]{text};
        }
        return this.rechunk(text.split("\\s"), maxWidth);
    }

    private String[] rechunk(String[] words, float maxWidth) {
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder currentLine = new StringBuilder();
        for (String word : words) {
            if (currentLine.isEmpty() || this.match(currentLine, word, maxWidth)) {
                currentLine.append(word).append(" ");
                continue;
            }
            lines.add(currentLine.toString().trim());
            currentLine = new StringBuilder(word);
        }
        lines.add(currentLine.toString().trim());
        return lines.toArray(new String[0]);
    }

    private boolean match(StringBuilder sb, String next, float maxWidth) {
        return this.font.width(sb.toString() + " " + next) <= maxWidth;
    }

    private boolean isBlank(String text) {
        return text == null || text.trim().length() == 0;
    }
}

