/*
 * Decompiled with CFR 0.152.
 */
package inspired.pdf.unbox.elements;

import inspired.pdf.unbox.Bounds;
import inspired.pdf.unbox.Document;
import inspired.pdf.unbox.Margin;
import inspired.pdf.unbox.Padding;
import inspired.pdf.unbox.base.Column;
import inspired.pdf.unbox.base.SimpleColumnModel;
import inspired.pdf.unbox.elements.Container;
import inspired.pdf.unbox.elements.PdfElement;

public class Row
extends Container {
    private final SimpleColumnModel columnModel = new SimpleColumnModel();

    @Override
    public Row add(PdfElement element) {
        super.add(element);
        this.columnModel.add(1.0f);
        return this;
    }

    @Override
    public Row with(Margin margin) {
        super.with(margin);
        return this;
    }

    @Override
    public Row with(Padding padding) {
        super.with(padding);
        return this;
    }

    @Override
    public float render(Document document, Bounds viewPort) {
        Bounds bounds = viewPort.apply(this.margin()).apply(this.padding());
        float forward = 0.0f;
        SimpleColumnModel columns = this.columnModel.scaleToSize(bounds.width());
        float offsetX = bounds.left();
        for (int i = 0; i < this.elements.size(); ++i) {
            PdfElement element = (PdfElement)this.elements.get(i);
            Column column = columns.get(i);
            Bounds adjusted = bounds.width(column.width()).left(offsetX);
            forward = Math.max(element.render(document, adjusted), forward);
            offsetX += column.width();
        }
        return forward + this.margin().vertical() + this.padding().vertical();
    }

    @Override
    public float innerHeight(Bounds viewPort) {
        return this.elements.stream().map(e -> Float.valueOf(e.innerHeight(viewPort))).max(Float::compareTo).orElse(Float.valueOf(0.0f)).floatValue() + this.padding().vertical();
    }
}

