/*
 * Decompiled with CFR 0.152.
 */
package inspired.pdf.unbox.elements;

import inspired.pdf.unbox.Align;
import inspired.pdf.unbox.Bounds;
import inspired.pdf.unbox.Document;
import inspired.pdf.unbox.Font;
import inspired.pdf.unbox.Margin;
import inspired.pdf.unbox.Padding;
import inspired.pdf.unbox.VAlign;
import inspired.pdf.unbox.elements.PdfElement;
import inspired.pdf.unbox.internal.SimpleFont;
import inspired.pdf.unbox.internal.TextWriter;

public class Paragraph
implements PdfElement {
    private static final float HEIGHT_UNDEFINED = -1.0f;
    private final TextWriter textWriter;
    private final String text;
    private Align align = Align.LEFT;
    private VAlign vAlign = VAlign.TOP;
    private float height = -1.0f;
    private Padding padding = Padding.of(4.0f);
    private Margin margin = Margin.none();

    public Paragraph(String text) {
        this(text, SimpleFont.helvetica(8.0f));
    }

    public Paragraph(String text, Font font) {
        this.textWriter = new TextWriter(font);
        this.text = text;
    }

    public Paragraph with(Margin margin) {
        this.margin = margin;
        return this;
    }

    public Paragraph with(Padding padding) {
        this.padding = padding;
        return this;
    }

    public Paragraph align(Align align) {
        this.align = align;
        return this;
    }

    public Paragraph align(VAlign vAlign) {
        this.vAlign = vAlign;
        return this;
    }

    public Paragraph align(Align align, VAlign vAlign) {
        this.align = align;
        this.vAlign = vAlign;
        return this;
    }

    public Paragraph withHeight(float height) {
        this.height = height;
        return this;
    }

    @Override
    public float render(Document document, Bounds viewPort) {
        Bounds bounds = this.effectiveBounds(viewPort);
        float actualHeight = this.textWriter.write(document.getContentStream(), bounds, this.text, this.align, this.vAlign);
        if (this.height > -1.0f) {
            return this.height;
        }
        if (VAlign.TOP == this.vAlign) {
            return actualHeight + this.padding.vertical();
        }
        return viewPort.height();
    }

    @Override
    public Margin margin() {
        return this.margin;
    }

    @Override
    public float innerHeight(Bounds viewPort) {
        if (this.height > -1.0f) {
            return this.height;
        }
        if (VAlign.TOP == this.vAlign) {
            return this.textWriter.calculateHeight(this.text, viewPort) + this.padding.vertical();
        }
        return viewPort.height();
    }

    private Bounds effectiveBounds(Bounds viewPort) {
        if (this.height > -1.0f) {
            return viewPort.apply(this.margin).height(this.height).apply(this.padding);
        }
        return viewPort.apply(this.margin).apply(this.padding);
    }
}

