/*
 * Decompiled with CFR 0.152.
 */
package inspired.pdf.unbox.base;

import inspired.pdf.unbox.Align;
import inspired.pdf.unbox.Bounds;
import inspired.pdf.unbox.Font;
import inspired.pdf.unbox.base.Column;
import inspired.pdf.unbox.base.ColumnModel;
import inspired.pdf.unbox.base.EmptyCell;
import inspired.pdf.unbox.elements.TableCell;
import inspired.pdf.unbox.elements.TextCell;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class TableModel
implements ColumnModel<TableColumn> {
    public static final float DEFAULT_WIDTH = 1.0f;
    public static TableColumn DEFAULT_COLUMN = new TableColumn("", 1.0f, Align.LEFT, null, null);
    private final List<TableColumn> columns = new ArrayList<TableColumn>();
    private final Map<Class, TableCell> defaultCells = new LinkedHashMap<Class, TableCell>();
    private static final TableCell emptyCell = new EmptyCell();

    public TableModel() {
        this.defaultCells.put(Number.class, new TextCell("", Align.RIGHT, null));
        this.defaultCells.put(Object.class, new TextCell(""));
    }

    private TableModel(List<TableColumn> columns) {
        this();
        this.columns.addAll(columns);
    }

    public static TableModel of(TableColumn ... columns) {
        return new TableModel(List.of(columns));
    }

    public TableModel add(TableColumn column) {
        this.columns.add(column);
        return this;
    }

    public TableModel add(TableColumn ... column) {
        this.columns.addAll(List.of(column));
        return this;
    }

    public TableModel add(String title) {
        return this.add(new TableColumn(title));
    }

    public TableModel add(String title, float width) {
        return this.add(new TableColumn(title, width, Align.LEFT, null, null));
    }

    public TableModel add(String title, Align align) {
        return this.add(new TableColumn(title, 1.0f, align, null, null));
    }

    public TableModel add(String title, float width, Align align) {
        return this.add(new TableColumn(title, width, align, null, null));
    }

    public TableModel add(String title, TableCell cell) {
        return this.add(new TableColumn(title, 1.0f, Align.LEFT, null, cell));
    }

    public TableModel add(String title, float width, TableCell cell) {
        return this.add(new TableColumn(title, width, Align.LEFT, null, cell));
    }

    public TableModel append(TableModel other) {
        this.columns.addAll(other.columns);
        return this;
    }

    @Override
    public TableColumn get(int index) {
        return this.columns.get(index);
    }

    public Align align(int index) {
        if (index >= this.columns.size()) {
            return Align.LEFT;
        }
        return this.get((int)index).align;
    }

    @Override
    public float getOverallWidth() {
        return this.columns.stream().map(TableColumn::width).reduce(Float::sum).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public TableModel scale(float scale) {
        List<TableColumn> adapted = this.columns.stream().map(c -> c.scale(scale)).collect(Collectors.toList());
        return new TableModel(adapted);
    }

    @Override
    public TableModel scaleToSize(float tableWidth) {
        return this.scale(tableWidth / this.getOverallWidth());
    }

    public List<Bounds> toBounds(Bounds viewPort) {
        ArrayList<Bounds> bounds = new ArrayList<Bounds>();
        float offset = viewPort.left();
        for (TableColumn colum : this.columns) {
            bounds.add(new Bounds(offset, viewPort.top(), colum.width, viewPort.height()));
            offset += colum.width;
        }
        return bounds;
    }

    @Override
    public int size() {
        return this.columns.size();
    }

    @Override
    public Iterator<TableColumn> iterator() {
        return this.columns.iterator();
    }

    public TableCell getDefaultCellFor(Object value) {
        if (value == null) {
            return emptyCell;
        }
        for (Map.Entry<Class, TableCell> entry : this.defaultCells.entrySet()) {
            if (!entry.getKey().isInstance(value)) continue;
            return entry.getValue();
        }
        throw new IllegalArgumentException("No cell found for value " + value.toString());
    }

    public static class TableColumn
    extends Column {
        private final float width;
        private final Align align;
        private final String title;
        private final Font font;
        private final TableCell cell;

        public TableColumn(String title) {
            this(title, 1.0f, Align.LEFT, null, null);
        }

        public TableColumn(String title, float width, Align align, Font font, TableCell cell) {
            super(width);
            this.width = width;
            this.align = align;
            this.title = title;
            this.font = font;
            this.cell = cell;
        }

        @Override
        public float width() {
            return this.width;
        }

        public Align align() {
            return this.align;
        }

        public Font font() {
            return this.font;
        }

        public String title() {
            return this.title;
        }

        public TableCell cell() {
            return this.cell;
        }

        @Override
        public TableColumn scale(float scale) {
            return new TableColumn(this.title, this.width * scale, this.align, this.font, this.cell);
        }
    }
}

