/*
 * Decompiled with CFR 0.152.
 */
package inspired.pdf.unbox;

import inspired.pdf.unbox.Margin;
import inspired.pdf.unbox.Padding;
import inspired.pdf.unbox.Position;

public record Bounds(float left, float top, float width, float height) {
    public float bottom() {
        return this.top - this.height;
    }

    public float center() {
        return this.left + this.width / 2.0f;
    }

    public float right() {
        return this.left + this.width;
    }

    public float middle() {
        return this.top - this.height / 2.0f;
    }

    public Position topLeft() {
        return new Position(this.left, this.top);
    }

    public Position topRight() {
        return new Position(this.right(), this.top);
    }

    public Position bottomLeft() {
        return new Position(this.left, this.bottom());
    }

    public Position bottomRight() {
        return new Position(this.right(), this.bottom());
    }

    public Bounds moveRight(float amount) {
        return new Bounds(this.left + amount, this.top, this.width, this.height);
    }

    public Bounds moveDown(float amount) {
        return new Bounds(this.left, this.top - amount, this.width, this.height);
    }

    public Bounds apply(Margin margin) {
        return new Bounds(this.left + margin.left(), this.top - margin.top(), this.width - margin.horizontal(), this.height - margin.vertical());
    }

    public Bounds apply(Padding padding) {
        return new Bounds(this.left + padding.left(), this.top - padding.top(), this.width - padding.horizontal(), this.height - padding.vertical());
    }

    public Bounds top(float top) {
        return new Bounds(this.left, top, this.width, this.height);
    }

    public Bounds left(float left) {
        return new Bounds(left, this.top, this.width, this.height);
    }

    public Bounds height(float height) {
        return new Bounds(this.left, this.top, this.width, height);
    }

    public Bounds width(float width) {
        return new Bounds(this.left, this.top, width, this.height);
    }
}

