/*
 * Decompiled with CFR 0.152.
 */
package inspired.pdf.unbox.elements.internal;

import inspired.pdf.unbox.Bounds;
import inspired.pdf.unbox.LinearPDFWriter;
import inspired.pdf.unbox.Margin;
import inspired.pdf.unbox.Position;
import inspired.pdf.unbox.base.Column;
import inspired.pdf.unbox.base.ColumnModel;
import inspired.pdf.unbox.decorators.Decorator;
import inspired.pdf.unbox.elements.Table;
import inspired.pdf.unbox.elements.TableRow;
import inspired.pdf.unbox.internal.PdfUnboxException;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDPageContentStream;

public abstract class AbstractTable
implements Table {
    private static final float GRID_STROKE = 0.4f;
    private final List<TableRow> headers = new ArrayList<TableRow>();
    private final List<TableRow> rows = new ArrayList<TableRow>();
    private final List<Decorator> decorators = new ArrayList<Decorator>();
    private Margin margin = Margin.of(0.0f);
    private boolean repeatHeader = true;
    private float tableStartOnPage;

    @Override
    public TableRow addRow() {
        return this.addRow(new TableRow());
    }

    @Override
    public TableRow addRow(TableRow row) {
        this.rows.add(row);
        return row;
    }

    @Override
    public TableRow addHeader(TableRow row) {
        this.headers.add(row);
        return row;
    }

    @Override
    public Table with(Decorator decorator) {
        this.decorators.add(decorator);
        return this;
    }

    public Table with(Margin margin) {
        this.margin = margin;
        return this;
    }

    @Override
    public float innerHeight(Bounds viewPort) {
        return 0.0f;
    }

    public Table repeatHeader(boolean repeat) {
        this.repeatHeader = repeat;
        return this;
    }

    @Override
    public float render(LinearPDFWriter writer, Bounds viewPort) {
        try {
            writer.forward(this.margin.top());
            this.tableStartOnPage = writer.getPosition();
            this.renderRows(writer, this.headers);
            this.renderRows(writer, this.rows);
            this.applyDecorators(writer);
            return this.margin.bottom();
        }
        catch (IOException e) {
            throw new PdfUnboxException(e);
        }
    }

    protected void onBeforeNewPage(LinearPDFWriter writer) {
    }

    protected void onAfterNewPage(LinearPDFWriter writer) {
    }

    protected Margin getMargin() {
        return this.margin;
    }

    protected float renderRow(LinearPDFWriter writer, TableRow row) {
        float rowHeight = row.innerHeight(writer.getViewPort());
        this.checkPageBreak(writer, rowHeight);
        Bounds bounds = writer.getCurrentViewPort().height(rowHeight);
        row.render(writer, bounds);
        this.drawRowLines(writer, rowHeight);
        return rowHeight;
    }

    public float getTableStartOnPage() {
        return this.tableStartOnPage;
    }

    private float renderRows(LinearPDFWriter writer, Iterable<TableRow> rows) throws IOException {
        float height = 0.0f;
        for (TableRow row : rows) {
            float rowHeight = this.renderRow(writer, row);
            writer.forward(rowHeight);
            height += rowHeight;
        }
        return height;
    }

    private void drawRowLines(LinearPDFWriter writer, float rowHeight) {
        try {
            PDPageContentStream contentStream = writer.getContentStream();
            contentStream.setLineWidth(0.4f);
            contentStream.setStrokingColor(Color.DARK_GRAY);
            Bounds bounds = writer.getCurrentViewPort().height(rowHeight);
            contentStream.moveTo(bounds.left(), bounds.top());
            contentStream.lineTo(bounds.right(), bounds.top());
            contentStream.stroke();
            contentStream.moveTo(bounds.left(), bounds.bottom());
            contentStream.lineTo(bounds.right(), bounds.bottom());
            contentStream.stroke();
        }
        catch (IOException e) {
            throw new PdfUnboxException(e);
        }
    }

    protected void drawColumnLines(LinearPDFWriter writer, ColumnModel<?> columns, Bounds bounds) {
        try {
            PDPageContentStream contentStream = writer.getContentStream();
            contentStream.setLineWidth(0.4f);
            contentStream.setStrokingColor(Color.DARK_GRAY);
            boolean first = true;
            for (Column col : columns) {
                if (first) {
                    first = false;
                } else {
                    this.drawLine(contentStream, bounds.topLeft(), bounds.bottomLeft());
                }
                bounds = bounds.moveRight(col.width());
            }
        }
        catch (IOException e) {
            throw new PdfUnboxException(e);
        }
    }

    private void drawLine(PDPageContentStream contentStream, Position start, Position end) {
        try {
            contentStream.moveTo(start.x(), start.y());
            contentStream.lineTo(end.x(), end.y());
            contentStream.stroke();
        }
        catch (IOException e) {
            throw new PdfUnboxException(e);
        }
    }

    private void checkPageBreak(LinearPDFWriter writer, float minSpace) {
        try {
            if (writer.getSpaceLeftOnPage() < minSpace) {
                this.applyDecorators(writer);
                this.onBeforeNewPage(writer);
                writer.addPage();
                writer.forward(this.margin.top());
                this.tableStartOnPage = writer.getPosition();
                this.onAfterNewPage(writer);
                if (this.repeatHeader) {
                    this.renderRows(writer, this.headers);
                }
            }
        }
        catch (IOException e) {
            throw new PdfUnboxException(e);
        }
    }

    private void applyDecorators(LinearPDFWriter writer) throws IOException {
        float height = this.tableStartOnPage - writer.getPosition();
        Bounds bounds = writer.getViewPort().top(this.tableStartOnPage).height(height);
        for (Decorator decorator : this.decorators) {
            decorator.render(writer, bounds);
        }
    }
}

