/*
 * Decompiled with CFR 0.152.
 */
package inspired.pdf.unbox.elements;

import inspired.pdf.unbox.Bounds;
import inspired.pdf.unbox.LinearPDFWriter;
import inspired.pdf.unbox.Margin;
import inspired.pdf.unbox.Padding;
import inspired.pdf.unbox.base.Column;
import inspired.pdf.unbox.base.SimpleColumnModel;
import inspired.pdf.unbox.elements.PdfElement;
import inspired.pdf.unbox.elements.internal.AbstractPdfElement;
import java.util.ArrayList;
import java.util.List;

public class Row
extends AbstractPdfElement {
    private final List<PdfElement> elements = new ArrayList<PdfElement>();
    private final SimpleColumnModel columnModel = new SimpleColumnModel();

    public Row add(PdfElement element) {
        this.elements.add(element);
        this.columnModel.add(1.0f);
        return this;
    }

    @Override
    public Row with(Margin margin) {
        super.with(margin);
        return this;
    }

    @Override
    public Row with(Padding padding) {
        super.with(padding);
        return this;
    }

    @Override
    public float render(LinearPDFWriter writer, Bounds viewPort) {
        Bounds bounds = viewPort.apply(this.margin()).apply(this.padding());
        float forward = 0.0f;
        SimpleColumnModel columns = this.columnModel.scaleToSize(bounds.width());
        float offsetX = bounds.left();
        for (int i = 0; i < this.elements.size(); ++i) {
            PdfElement element = this.elements.get(i);
            Column column = columns.get(i);
            Bounds adjusted = bounds.width(column.width()).left(offsetX);
            forward = Math.max(element.render(writer, adjusted), forward);
            offsetX += column.width();
        }
        return forward + this.margin().vertical() + this.padding().vertical();
    }

    @Override
    public float innerHeight(Bounds viewPort) {
        return this.elements.stream().map(e -> Float.valueOf(e.innerHeight(viewPort))).max(Float::compareTo).orElse(Float.valueOf(0.0f)).floatValue() + this.padding().vertical();
    }
}

