/*
 * Decompiled with CFR 0.152.
 */
package inspired.pdf.unbox.elements;

import inspired.pdf.unbox.Bounds;
import inspired.pdf.unbox.LinearPDFWriter;
import inspired.pdf.unbox.base.ColumnModel;
import inspired.pdf.unbox.base.TableModel;
import inspired.pdf.unbox.elements.TableRow;
import inspired.pdf.unbox.elements.internal.AbstractTable;

public class FixedColumnsTable
extends AbstractTable {
    private final TableModel model;

    public FixedColumnsTable(TableModel model) {
        this.model = model;
    }

    @Override
    public TableRow addRow() {
        return this.addRow(new TableRow(this.model));
    }

    @Override
    protected float renderRow(LinearPDFWriter writer, TableRow row) {
        float rowHeight = super.renderRow(writer, row);
        TableModel columns = this.model.scaleToSize(writer.getViewPort().width());
        this.drawColumnLines(writer, columns, rowHeight);
        return rowHeight;
    }

    private void drawColumnLines(LinearPDFWriter writer, ColumnModel<?> columns, float height) {
        Bounds viewPort = writer.getViewPort();
        Bounds bounds = new Bounds(viewPort.left(), writer.getPosition(), viewPort.width(), height);
        this.drawColumnLines(writer, columns, bounds);
    }
}

