/*
 * Decompiled with CFR 0.152.
 */
package inspired.pdf.unbox.decorators;

import inspired.pdf.unbox.Bounds;
import inspired.pdf.unbox.LinearPDFWriter;
import inspired.pdf.unbox.Margin;
import inspired.pdf.unbox.elements.PdfElement;

public abstract class Decorator
implements PdfElement {
    private PdfElement wrappedElement = null;

    public Decorator wrap(PdfElement element) {
        this.wrappedElement = element;
        return this;
    }

    public abstract float decorate(LinearPDFWriter var1, Bounds var2);

    @Override
    public final float render(LinearPDFWriter writer, Bounds viewPort) {
        if (this.wrappedElement != null) {
            float height = this.wrappedElement.innerHeight(viewPort);
            this.decorate(writer, viewPort.apply(this.wrappedElement.margin()).height(height));
            return this.wrappedElement.render(writer, viewPort);
        }
        return this.decorate(writer, viewPort);
    }

    @Override
    public Margin margin() {
        if (this.wrappedElement != null) {
            return this.wrappedElement.margin();
        }
        return Margin.none();
    }

    @Override
    public float innerHeight(Bounds viewPort) {
        if (this.wrappedElement != null) {
            return this.wrappedElement.innerHeight(viewPort);
        }
        return 0.0f;
    }
}

