/*
 * Decompiled with CFR 0.152.
 */
package inspired.pdf.unbox;

import inspired.pdf.unbox.DocumentContext;
import inspired.pdf.unbox.LinearPDFWriter;
import inspired.pdf.unbox.internal.PdfEventListener;
import inspired.pdf.unbox.internal.PdfUnboxException;
import java.io.IOException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.PDPageTree;

public abstract class DocumentFinisher
implements PdfEventListener {
    public abstract void finish(DocumentContext var1, PDPageContentStream var2, int var3, int var4);

    protected void finish(LinearPDFWriter writer, PDDocument document, PDPageTree allPages) throws IOException {
        int pageNum = 1;
        for (PDPage page : allPages) {
            PDPageContentStream contentStream = new PDPageContentStream(document, page, PDPageContentStream.AppendMode.APPEND, true, true);
            this.finish(writer, contentStream, pageNum, allPages.getCount());
            contentStream.close();
            ++pageNum;
        }
    }

    @Override
    public void onFinished(LinearPDFWriter writer) {
        PDDocument document = writer.getDocument();
        PDPageTree allPages = document.getDocumentCatalog().getPages();
        try {
            this.finish(writer, document, allPages);
        }
        catch (IOException e) {
            throw new PdfUnboxException(e);
        }
    }
}

