/*
 *
 *  * Copyright (c) 2021. Tap Payments
 *  * @author <a href="mailto:c.dommara@tap.company">Charan Dommara</a>
 *  * Created On: 21 1 2021
 *
 */

package company.tap.commondependencies.Helpers;

import com.google.common.base.Strings;
import company.tap.commondependencies.Models.SmsModel;
import lombok.NoArgsConstructor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Component;

import javax.mail.internet.MimeMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Component
public class NotificationHelper {

    private static final Logger logger = LogManager.getLogger(NotificationHelper.class);


    private static JavaMailSender javaMailSender;

    @Autowired
    public void setJavaMailSender(JavaMailSender javaMailSender) {
        this.javaMailSender = javaMailSender;
    }

    public static boolean sendMail(String To, String body, String subject) {
        logger.info("##### send mail #####");
        try {
            MimeMessage message = javaMailSender.createMimeMessage();

            MimeMessageHelper msg = new MimeMessageHelper(message, true);
            msg.setFrom("reporting_no_reply@tap.company");
            msg.setTo(To);
            msg.setSubject(subject);
            msg.setText(body, true);
            javaMailSender.send(message);
            logger.info("##### #### #### #####");
            return true;
        } catch (Exception e) {
            logger.info("##### send mail error #####");
            e.printStackTrace();
            logger.info(e.getLocalizedMessage());
            logger.info("##### #### #### #####");
            return false;
        }
    }

    public static boolean sendSMS(String message, String code, String number, String url) {
        try {

            logger.info("##### send mail #####");
            SmsModel sms = new SmsModel();
            List<SmsModel.smsRequest> ss = new ArrayList<>();

            SmsModel.smsRequest s = new SmsModel.smsRequest();
            s.sender_id = "Tap";
            s.language = "EN";
            s.body = message;
            SmsModel.phone p = new SmsModel.phone();
            p.country_code = code;
            p.number = number;
            SmsModel.customer c = new SmsModel.customer();
            c.phone = p;
            s.customer = c;
            ss.add(s);

            sms.sms_request = ss;
            HttpHeaders headersCard = new HttpHeaders();
            headersCard.setAccept(Arrays.asList(MediaType.APPLICATION_JSON));
            HttpEntity<SmsModel> entitySms = new HttpEntity<>(sms, headersCard);
            if (Strings.isNullOrEmpty(url))
                url = "https://api.payments.tap.company/v2/notifications/private/sms";
            String Check = RestAPI.getInstance().exchange(url, HttpMethod.POST, entitySms, String.class).getBody();
            if (Check.contains("success"))
                return true;
            else
                return false;
        } catch (Exception e) {
            logger.info("##### send SMS error #####");
            e.printStackTrace();
            logger.error(e.getMessage());
            logger.info("##### #### #### #####");
            return false;
        }
    }

    public static void sendSlackMessage(String appName, String message, String channel, String url) {
        logger.info("##### sendSlackMessage #####");
        try {
            Slack slack = new Slack();
            slack.channel = channel;
            slack.text = appName + " : " + message;
            HttpHeaders headersCard = new HttpHeaders();
            headersCard.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity<Slack> entityHea = new HttpEntity<>(slack, headersCard);
            if (Strings.isNullOrEmpty(url))
                url = "https://api.payments.tap.company/v2/notifications/private/slack";
            RestAPI.getInstance()
                    .exchange(url, HttpMethod.POST, entityHea, String.class)
                    .getBody();

        } catch (Exception e) {
            logger.info("##### send SlackMessage error #####");
            e.printStackTrace();
            logger.error(e.getMessage());
            logger.info("##### #### #### #####");
        }

    }

    @NoArgsConstructor
    public static class Slack {
        public String channel;

        public String text;
    }
}
