/*
 *
 *  * Copyright (c) 2021. Tap Payments
 *  * @author <a href="mailto:c.dommara@tap.company">Charan Dommara</a>
 *  * Created On: 21 1 2021
 *
 */

package company.tap.commondependencies.Aspect;

import company.tap.commondependencies.exceptions.UnauthorizedException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

@Aspect
@Configuration
@Component
public class AccessAspect {

    @Value("${app.CommonDependencyAuth}")
    private String commonDependencyAuth;

    private Logger logger = LogManager.getLogger(this.getClass());

    //What kind of method calls I would intercept
    //execution(* PACKAGE.*.*(..))
    //Weaving & Weaver
    @Before("execution(* company.tap.commondependencies.*.*(..))")
    public void before(JoinPoint joinPoint) {
        //Advice
        logger.info(" Check for access ");
        if (!commonDependencyAuth.equals("TapCommonAccess"))
            throw new UnauthorizedException("Unauthorized");
        logger.info(" Allowed execution for {}", joinPoint);
    }
}
