package company.tap.commondependencies.ApiModels;

import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotEmpty;
import java.util.List;

@Data
@NoArgsConstructor
@JsonInclude(value = JsonInclude.Include.NON_NULL)
public class ApiMerchant extends ApiBaseModel {
    public String display_name;
    @NotEmpty(message = "Please provide a business_id")
    public String business_id;
    @NotEmpty(message = "Please provide a business_entity_id;")
    public String business_entity_id;
    public String brand_id;
    public String branch_id;
    public String wallet_id;
    public String base_currency;
    public List<String> charge_currenices;
    public ApiWallet wallets;
    public ApiBankAccount bank_account;

    public String settlement_by;
    public ApiSettlement settlement; //Added on 27OCT
    public String country;
    public String email; //Added on 19DEC21
}
