/*
 *
 *  * Copyright (c) 2021. Tap Payments
 *  * @author <a href="mailto:c.dommara@tap.company">Charan Dommara</a>
 *  * Created On: 21 1 2021
 *
 */

package company.tap.commondependencies.Mada.StandardCodes;

public class PointOfService {

    public enum Position1 {
        _0_Unknown("0"),
        _1_Manual_noTerminal("1"),
        _2_MagneticStripeRead("2"),
        _3_BarCode("3"),
        _4_OCR("4"),
        _5_ICC("5"),
        _6_KeyEntered("6"),
        _7_ContactLess("7"),
        _8_ElectronicCommerce3DS("8"),
        _9_ElectronicCommerceEMV("9"),
        _A_CardOnFile("A");
        private String code;

        Position1(String code) {
            this.code = code;
        }

        public String getCode() {
            return code;
        }

        public static String get(String abbreviation) {
            for (Position1 e : Position1.values()) {
                if (e.code == abbreviation) return e.name();
            }
            return null;
        }
    }

    public enum Position2 {
        _0_NoElectronicAuthentication("0"),
        _1_PIN("1"),
        _2_ElectronicSignatureAnalysis("2"),
        _3_BiometricsOrPasscodeOnConsumerDevice("3"),
        _4_Biographic("4"),
        _5_ElectronicAuthenticationInoperative("5"),
        _6_Other("6");
        private String code;

        Position2(String code) {
            this.code = code;
        }

        public String getCode() {
            return code;
        }

        public static String get(String abbreviation) {
            for (Position2 e : Position2.values()) {
                if (e.code == abbreviation) return e.name();
            }
            return null;
        }
    }

    public enum Position3 {
        _0_None("0"),
        _1_Capture("1");

        private String code;

        Position3(String code) {
            this.code = code;
        }

        public String getCode() {
            return code;
        }

        public static String get(String abbreviation) {
            for (Position3 e : Position3.values()) {
                if (e.code == abbreviation) return e.name();
            }
            return null;
        }
    }

    public enum Position4 {
        _0_NoTerminalUsed("0"),
        _1_OnPremisesOfCardAcceptorAttended("1"),
        _2_OnPremisesOfCardAcceptorUnAttended("2"),
        _3_OffPremisesOfCardAcceptorAttended("3"),
        _4_OffPremisesOfCardAcceptorUnAttended("4"),
        _5_OnPremisesOfCardHolderUnAttended("5");
        private String code;

        Position4(String code) {
            this.code = code;
        }

        public String getCode() {
            return code;
        }

        public static String get(String abbreviation) {
            for (Position4 e : Position4.values()) {
                if (e.code == abbreviation) return e.name();
            }
            return null;
        }
    }

    public enum Position5 {
        _0_CardholderPresent("0"),
        _1_CardholderNotPresentUnspecified("1"),
        _2_CardholderNotPresentMailOrder("2"),
        _3_CardholderNotPresentTelephone("3"),
        _4_CardholderNotPresentStandInAuthorization("4");
        private String code;

        Position5(String code) {
            this.code = code;
        }

        public String getCode() {
            return code;
        }

        public static String get(String abbreviation) {
            for (Position5 e : Position5.values()) {
                if (e.code == abbreviation) return e.name();
            }
            return null;
        }
    }

    public enum Position6 {
        _0_CardNotPresent("0"),
        _1_CardPresent("1");
        private String code;

        Position6(String code) {
            this.code = code;
        }

        public String getCode() {
            return code;
        }

        public static String get(String abbreviation) {
            for (Position6 e : Position6.values()) {
                if (e.code == abbreviation) return e.name();
            }
            return null;
        }
    }

    public enum Position7 {
        _0_Unspecified("0"),
        _1_ManualNoTerminal("1"),
        _2_MagneticStripeRead("2"),
        _3_BarCode("3"),
        _4_OCR("4"),
        _5_ICC("5"),
        _6_KeyEntered("6"),
        _7_Contactless("7"),
        _8_ElectronicCommerce3DS("8"),
        _9_ElectronicCommerceEMV("9"),
        _A_CardOnFile("A");
        private String code;

        Position7(String code) {
            this.code = code;
        }

        public String getCode() {
            return code;
        }

        public static String get(String abbreviation) {
            for (Position7 e : Position7.values()) {
                if (e.code == abbreviation) return e.name();
            }
            return null;
        }

    }

    public enum Position8 {

        _0_NotAuthenticated("0"),
        _1_PIN("1"),
        _2_ElectronicSignatureAnalysis("2"),
        _3_BiometricOrDevicePasscode("3"),
        _4_Biographic("4"),
        _5_ManualSignatureAnalysis("5"),
        _6_OtherManualVerification("6"),
        _8_eCommerce3DSOrMO_TCVV2Verification("8");
        private String code;

        Position8(String code) {
            this.code = code;
        }

        public String getCode() {
            return code;
        }

        public static String get(String abbreviation) {
            for (Position8 e : Position8.values()) {
                if (e.code == abbreviation) return e.name();
            }
            return null;
        }
    }

    public enum Position9 {
        _0_NotAuthenticated("0"),
        _1_ICC("1"),
        _2_CAD("2"),
        _3_AuthorisingAgent("3"),
        _4_ByMerchant("4"),
        _5_Other("5");
        private String code;

        Position9(String code) {
            this.code = code;
        }

        public String getCode() {
            return code;
        }

        public static String get(String abbreviation) {
            for (Position9 e : Position9.values()) {
                if (e.code == abbreviation) return e.name();
            }
            return null;
        }

    }

    public enum Position10 {
        _0_Unknown("0"),
        _1_None("1"),
        _2_MagneticStripeWrite("2"),
        _3_ICC("3");
        private String code;

        Position10(String code) {
            this.code = code;
        }

        public String getCode() {
            return code;
        }

        public static String get(String abbreviation) {
            for (Position10 e : Position10.values()) {
                if (e.code == abbreviation) return e.name();
            }
            return null;
        }

    }

    public enum Position11 {
        _0_Unknown("0"),
        _1_None("1"),
        _2_Printing("2"),
        _3_Display("3"),
        _4_PrintingAndDisplay("4");
        private String code;

        Position11(String code) {
            this.code = code;
        }

        public String getCode() {
            return code;
        }

        public static String get(String abbreviation) {
            for (Position11 e : Position11.values()) {
                if (e.code == abbreviation) return e.name();
            }
            return null;
        }

    }

    public enum Position12 {
        _0_NoPINCaptureCapability("0"),
        _1_DevicePINCaptureCapabilityUnknown("1"),
        _4_FourCharacters("4"),
        _5_FiveCharacters("5"),
        _6_SixCharacters("6"),
        _7_SevenCharacters("7"),
        _8_EightCharacters("8"),
        _9_NineCharacters("9"),
        _A_TenCharacters("A"),
        _B_ElevenCharacters("B"),
        _C_TwelveCharacters("C");
        private String code;

        Position12(String code) {
            this.code = code;
        }

        public String getCode() {
            return code;
        }

        public static String get(String abbreviation) {
            for (Position12 e : Position12.values()) {
                if (e.code == abbreviation) return e.name();
            }
            return null;
        }

    }

    public static String generateDE22(Position1 position1, Position2 position2, Position3 position3,
                                      Position4 position4, Position5 position5, Position6 position6,
                                      Position7 position7, Position8 position8, Position9 position9,
                                      Position10 position10, Position11 position11, Position12 position12) {
        return position1.code + position2.code + position3.code + position4.code + position5.code + position6.code
                + position7.code + position8.code + position9.code + position10.code + position11.code + position12.code;
    }
}
