/*
 *
 *  * Copyright (c) 2021. Tap Payments
 *  * @author <a href="mailto:c.dommara@tap.company">Charan Dommara</a>
 *  * Created On: 21 1 2021
 *
 */

package company.tap.commondependencies.Mada.StandardCodes;

public class PointOfService {

    public enum Position1 {
        Unknown("0"),
        Manual_noTerminal("1"),
        MagneticStripeRead("2"),
        BarCode("3"),
        OCR("4"),
        ICC("5"),
        KeyEntered("6"),
        ContactLess("7"),
        ElectronicCommerce3DS("8"),
        ElectronicCommerceEMV("9"),
        CardOnFile("A");
        private String code;

        Position1(String code) {
            this.code = code;
        }

        public String getCode() {
            return code;
        }

        public static String get(String abbreviation) {
            for (Position1 e : Position1.values()) {
                if (e.code == abbreviation) return e.name();
            }
            return null;
        }
    }

    public enum Position2 {
        NoElectronicAuthentication("0"),
        PIN("1"),
        ElectronicSignatureAnalysis("2"),
        BiometricsOrPasscodeOnConsumerDevice("3"),
        Biographic("4"),
        ElectronicAuthenticationInoperative("5"),
        Other("6");
        private String code;

        Position2(String code) {
            this.code = code;
        }

        public String getCode() {
            return code;
        }

        public static String get(String abbreviation) {
            for (Position2 e : Position2.values()) {
                if (e.code == abbreviation) return e.name();
            }
            return null;
        }
    }

    public enum Position3 {
        None("0"),
        Capture("1");

        private String code;

        Position3(String code) {
            this.code = code;
        }

        public String getCode() {
            return code;
        }

        public static String get(String abbreviation) {
            for (Position3 e : Position3.values()) {
                if (e.code == abbreviation) return e.name();
            }
            return null;
        }
    }

    public enum Position4 {
        NoTerminalUsed("0"),
        OnPremisesOfCardAcceptorAttended("1"),
        OnPremisesOfCardAcceptorUnAttended("2"),
        OffPremisesOfCardAcceptorAttended("3"),
        OffPremisesOfCardAcceptorUnAttended("4"),
        OnPremisesOfCardHolderUnAttended("5");
        private String code;

        Position4(String code) {
            this.code = code;
        }

        public String getCode() {
            return code;
        }

        public static String get(String abbreviation) {
            for (Position4 e : Position4.values()) {
                if (e.code == abbreviation) return e.name();
            }
            return null;
        }
    }

    public enum Position5 {
        CardholderPresent("0"),
        CardholderNotPresentUnspecified("1"),
        CardholderNotPresentMailOrder("2"),
        CardholderNotPresentTelephone("3"),
        CardholderNotPresentStandInAuthorization("4");
        private String code;

        Position5(String code) {
            this.code = code;
        }

        public String getCode() {
            return code;
        }

        public static String get(String abbreviation) {
            for (Position5 e : Position5.values()) {
                if (e.code == abbreviation) return e.name();
            }
            return null;
        }
    }

    public enum Position6 {
        CardNotPresent("0"),
        CardPresent("1");
        private String code;

        Position6(String code) {
            this.code = code;
        }

        public String getCode() {
            return code;
        }

        public static String get(String abbreviation) {
            for (Position6 e : Position6.values()) {
                if (e.code == abbreviation) return e.name();
            }
            return null;
        }
    }

    public enum Position7 {
        Unspecified("0"),
        ManualNoTerminal("1"),
        MagneticStripeRead("2"),
        BarCode("3"),
        OCR("4"),
        ICC("5"),
        KeyEntered("6"),
        Contactless("7"),
        ElectronicCommerce3DS("8"),
        ElectronicCommerceEMV("9"),
        CardOnFile("A");
        private String code;

        Position7(String code) {
            this.code = code;
        }

        public String getCode() {
            return code;
        }

        public static String get(String abbreviation) {
            for (Position7 e : Position7.values()) {
                if (e.code == abbreviation) return e.name();
            }
            return null;
        }

    }

    public enum Position8 {

        NotAuthenticated("0"),
        PIN("1"),
        ElectronicSignatureAnalysis("2"),
        BiometricOrDevicePasscode("3"),
        Biographic("4"),
        ManualSignatureAnalysis("5"),
        OtherManualVerification("6"),
        eCommerce3DSOrMO_TCVV2Verification("8");
        private String code;

        Position8(String code) {
            this.code = code;
        }

        public String getCode() {
            return code;
        }

        public static String get(String abbreviation) {
            for (Position8 e : Position8.values()) {
                if (e.code == abbreviation) return e.name();
            }
            return null;
        }
    }

    public enum Position9 {
        NotAuthenticated("0"),
        ICC("1"),
        CAD("2"),
        AuthorisingAgent("3"),
        ByMerchant("4"),
        Other("5");
        private String code;

        Position9(String code) {
            this.code = code;
        }

        public String getCode() {
            return code;
        }

        public static String get(String abbreviation) {
            for (Position9 e : Position9.values()) {
                if (e.code == abbreviation) return e.name();
            }
            return null;
        }

    }

    public enum Position10 {
        Unknown("0"),
        None("1"),
        MagneticStripeWrite("2"),
        ICC("3");
        private String code;

        Position10(String code) {
            this.code = code;
        }

        public String getCode() {
            return code;
        }

        public static String get(String abbreviation) {
            for (Position10 e : Position10.values()) {
                if (e.code == abbreviation) return e.name();
            }
            return null;
        }

    }

    public enum Position11 {
        Unknown("0"),
        None("1"),
        Printing("2"),
        Display("3"),
        PrintingAndDisplay("4");
        private String code;

        Position11(String code) {
            this.code = code;
        }

        public String getCode() {
            return code;
        }

        public static String get(String abbreviation) {
            for (Position11 e : Position11.values()) {
                if (e.code == abbreviation) return e.name();
            }
            return null;
        }

    }

    public enum Position12 {
        NoPINCaptureCapability("0"),
        DevicePINCaptureCapabilityUnknown("1"),
        FourCharacters("4"),
        FiveCharacters("5"),
        SixCharacters("6"),
        SevenCharacters("7"),
        EightCharacters("8"),
        NineCharacters("9"),
        TenCharacters("A"),
        ElevenCharacters("B"),
        TwelveCharacters("C");
        private String code;

        Position12(String code) {
            this.code = code;
        }

        public String getCode() {
            return code;
        }

        public static String get(String abbreviation) {
            for (Position12 e : Position12.values()) {
                if (e.code == abbreviation) return e.name();
            }
            return null;
        }

    }

    public static String generateDE22(Position1 position1, Position2 position2, Position3 position3,
                                      Position4 position4, Position5 position5, Position6 position6,
                                      Position7 position7, Position8 position8, Position9 position9,
                                      Position10 position10, Position11 position11, Position12 position12) {
        return position1.code + position2.code + position3.code + position4.code + position5.code + position6.code
                + position7.code + position8.code + position9.code + position10.code + position11.code + position12.code;
    }
}
