package company.tap.commondependencies.Country;

import company.tap.commondependencies.ApiModels.Name;
import company.tap.commondependencies.Helpers.DataUtilities;
import company.tap.commondependencies.Helpers.RestAPI;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;

import java.io.*;
import java.util.NoSuchElementException;

import static org.springframework.http.MediaType.APPLICATION_JSON;

@Service
class CountryServices implements ICountryServices {

    private final String CommonApi = DataUtilities.getInstance().getUrlCommonUtilities();

    public Country getCountryByCountryIso(String CountryCode) {
        try {
            HttpHeaders headersCA = new HttpHeaders();
            headersCA.setContentType(APPLICATION_JSON);
            HttpEntity<String> entityToken = new HttpEntity<>(headersCA);
            return RestAPI.getInstance()
                    .exchange(CommonApi + "country/iso/" + CountryCode, HttpMethod.GET, entityToken, Country.class)
                    .getBody();

        } catch (Exception e) {
            return null;
        }
    }

    public Country getCountryByCountryId(String CountryId) {
        try {
            HttpHeaders headersCA = new HttpHeaders();
            headersCA.setContentType(APPLICATION_JSON);
            HttpEntity<String> entityToken = new HttpEntity<>(headersCA);
            return RestAPI.getInstance()
                    .exchange(CommonApi + "country/" + CountryId, HttpMethod.GET, entityToken, Country.class)
                    .getBody();

        } catch (Exception e) {
            return null;
        }
    }

    private JSONArray getCountries() {
        //JSON parser object to parse read file
        JSONParser jsonParser = new JSONParser();
        Resource resource = new ClassPathResource("Countries.json");
        try (InputStreamReader reader = new InputStreamReader(resource.getInputStream())) {
            //Read JSON file
            Object obj = jsonParser.parse(reader);
            return (JSONArray) obj;
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public Country getCountryByCountryIsoLocal(String code) {
        try {
            JSONArray countries = getCountries();
            if (countries == null)
                return null;
            JSONObject country;
            if (code.length() == 2)
                country =
                        (JSONObject) countries.stream().filter(jsonValue -> ((JSONObject) jsonValue).get("iso2").equals(code.toUpperCase())).findFirst().get();
            else
                country =
                        (JSONObject) countries.stream().filter(jsonValue -> ((JSONObject) jsonValue).get("iso3").equals(
                                code.toUpperCase())).findFirst().get();
            return prepareResponseObject(country);
        } catch (NoSuchElementException e) {
            return null;
        }
    }

    @Override
    public Country getCountryByCountryIdLocal(String CountryId) {
        try {
            JSONArray countries = getCountries();
            if (countries == null)
                return null;
            JSONObject country =
                    (JSONObject) countries.stream().filter(jsonValue -> ((JSONObject) jsonValue).get("countryId").equals(
                            CountryId)).findFirst().get();
            return prepareResponseObject(country);
        } catch (NoSuchElementException e) {
            return null;
        }
    }

    private Country prepareResponseObject(JSONObject jsonObject) {
        Country country = new Country();
        country.countryId = jsonObject.get("countryId").toString();
        country.capital = jsonObject.get("capital").toString();
        country.continent = jsonObject.get("continent").toString();
        country.geoNameId = jsonObject.get("geoNameId").toString();
        country.idd_prefix = jsonObject.get("idd_prefix").toString();
        country.iso2 = jsonObject.get("iso2").toString();
        country.iso3 = jsonObject.get("iso3").toString();
        country.numeric = jsonObject.get("numeric").toString();
        JSONObject name = (JSONObject) jsonObject.get("name");
        Name countryName = new Name();
        countryName.arabic = name.get("arabic").toString();
        countryName.english = name.get("english").toString();
        countryName.chinese = name.get("chinese").toString();
        countryName.russian = name.get("russian").toString();
        countryName.spanish = name.get("spanish").toString();
        countryName.french = name.get("french").toString();
        country.name = countryName;
        country.created = Long.parseLong(jsonObject.get("created").toString());
        return country;
    }


}
