/*
 *
 *  * Copyright (c) 2021. Tap Payments
 *  * @author <a href="mailto:c.dommara@tap.company">Charan Dommara</a>
 *  * Created On: 21 1 2021
 *
 */

package company.tap.commondependencies.Mada.StandardCodes;

public enum MessageReasonCodes {
    MadaPreAuthorizationVoidOrPartialVoid(1151, "Mada PreAuthorization Void or Partial Void"),
    MadaPreAuthorizationExpiryExtension(1152, "Mada PreAuthorization Expiry Extension"),
    FormatErrorNoActionTaken(4003, "Format error, no action taken"),
    TimeoutWaitingForResponse(4021, "Timeout waiting for response"),
    MAC_Failure(4352, "MAC Failure");
    private int code;
    private String description;

    public int getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

    MessageReasonCodes(int code, String description) {
        this.code = code;
        this.description = description;
    }

    public static MessageReasonCodes get(int code) {
        for (MessageReasonCodes e : MessageReasonCodes.values()) {
            if (e.code == code) return e;
        }
        return null;
    }
}
