/*
 * Copyright (c) 2021. Tap Payments
 * Author: Charan Dommara
 * Created On: 8 6 2021
 */

package company.tap.commondependencies.ApiModels;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import java.util.List;

@Data
@NoArgsConstructor
@EqualsAndHashCode(callSuper = false)
@JsonInclude(value = JsonInclude.Include.NON_NULL)
public class ApiTransactionBalance extends ApiBaseModel {
    @JsonProperty("balance_id")
    @JsonIgnore
    private String balanceId;
    private String type;
    @JsonProperty("wallet_id")
    private String walletId;
    private String currency;
    private double amount;
    private TransactionDetails authorized;
    private TransactionDetails voided;
    private List<CaptureTransactionDetails> captured;
    private Reference reference;
    @JsonProperty("capture_id")
    private String captureId;
    @JsonProperty("settlement_id")
    private String settlementId;

    @Data
    @NoArgsConstructor
    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    public static class TransactionDetails {
        private String id;
        private double amount;
        private long created;
    }

    @Data
    @NoArgsConstructor
    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    public static class CaptureTransactionDetails {
        private String id;
        private double amount;
        private long created;
        @JsonProperty("post_id")
        private String postId;
        @JsonProperty("post_date")
        private Long postDate;
        private List<TransactionDetails> settled;
    }

    /**
     * id is transaction Id
     * reference can be charge Id or top Id
     */
    @Data
    @NoArgsConstructor
    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    public static class Reference {
        private String id;
        private String reference;
    }
}
