package company.tap.commondependencies.Cipher;

import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;

import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

import org.springframework.stereotype.Service;

@Service
class DataCipherAes implements IDataCipherAes {

	private Cipher _Cipher;
    private Key SecretKey;
    private IvParameterSpec ivParameterSpec;

    private void init(String UniqueKey) throws NoSuchAlgorithmException, NoSuchPaddingException {
        UniqueKey = Base64.getEncoder().encodeToString(UniqueKey.getBytes(StandardCharsets.UTF_8));
        MessageDigest md = MessageDigest.getInstance("SHA-256"); // SHA-256, MD5
		// = key.getBytes(StandardCharsets.UTF_8);
		byte[] key_Array = md.digest(UniqueKey.getBytes(StandardCharsets.UTF_8));
        _Cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
        // Initialization vector.
        // It could be any value or generated using a random number generator.
        UniqueKey = Base64.getEncoder().encodeToString(UniqueKey.getBytes(StandardCharsets.UTF_8));
        byte[] iv = Arrays.copyOf(UniqueKey.getBytes(StandardCharsets.UTF_16BE), 16);
		ivParameterSpec = new IvParameterSpec(iv);
        key_Array = Arrays.copyOf(key_Array, 32);
        SecretKey = new SecretKeySpec(key_Array, "AES");
    }

    public String Encrypt(String Key, String strToEncrypt) {
        try {
            init(Key);
            _Cipher.init(Cipher.ENCRYPT_MODE, SecretKey, ivParameterSpec);
            return URLEncoder.encode(Base64.getEncoder().encodeToString(_Cipher.doFinal(strToEncrypt.getBytes())), StandardCharsets.UTF_8);
        } catch (Exception e) {
            System.out.println("[Exception]:" + e.getMessage());
        }
        return null;
    }

    public String Decrypt(String Key, String EncryptedMessage) {
        try {
            init(Key);
            _Cipher.init(Cipher.DECRYPT_MODE, SecretKey, ivParameterSpec);
            byte[] DecodedMessage = Base64.getDecoder().decode(URLDecoder.decode(EncryptedMessage, StandardCharsets.UTF_8));
            return new String(_Cipher.doFinal(DecodedMessage));

        } catch (Exception e) {
            System.out.println("[Exception]:" + e.getMessage());

        }
        return null;
    }


}
