/*
 * Decompiled with CFR 0.152.
 */
package company.tap.commondependencies.Cipher;

import company.tap.commondependencies.Cipher.IDataCipherRsa;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import javax.crypto.Cipher;
import org.springframework.stereotype.Service;

@Service
class DataCipherRsa
implements IDataCipherRsa {
    DataCipherRsa() {
    }

    private PublicKey getPublicKey(String base64PublicKey) {
        base64PublicKey = base64PublicKey.replace("-----BEGIN PUBLIC KEY-----", "");
        base64PublicKey = base64PublicKey.replace("-----END PUBLIC KEY-----", "");
        base64PublicKey = base64PublicKey.replaceAll("\\s+", "");
        try {
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(Base64.getDecoder().decode(base64PublicKey.getBytes()));
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            e.printStackTrace();
            return null;
        }
    }

    private PrivateKey getPrivateKey(String base64PrivateKey) {
        KeyFactory keyFactory;
        base64PrivateKey = base64PrivateKey.replace("-----BEGIN RSA PRIVATE KEY-----", "");
        base64PrivateKey = base64PrivateKey.replace("-----END RSA PRIVATE KEY-----", "");
        base64PrivateKey = base64PrivateKey.replaceAll("\\s+", "");
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(Base64.getDecoder().decode(base64PrivateKey.getBytes()));
        try {
            keyFactory = KeyFactory.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
        try {
            return keyFactory.generatePrivate(keySpec);
        }
        catch (InvalidKeySpecException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String Encrypt(String plainText, String publicKey) {
        try {
            Cipher encryptCipher = Cipher.getInstance("RSA");
            encryptCipher.init(1, this.getPublicKey(publicKey));
            byte[] cipherText = encryptCipher.doFinal(plainText.getBytes());
            return Base64.getEncoder().encodeToString(cipherText);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String Decrypt(String privateKey, String cipherText) {
        try {
            byte[] bytes = Base64.getDecoder().decode(cipherText);
            Cipher decriptCipher = Cipher.getInstance("RSA");
            decriptCipher.init(2, this.getPrivateKey(privateKey));
            return new String(decriptCipher.doFinal(bytes));
        }
        catch (Exception e) {
            return null;
        }
    }
}

