/*
 * Decompiled with CFR 0.152.
 */
package company.tap.commondependencies.Currency;

import company.tap.commondependencies.Country.Country;
import company.tap.commondependencies.Country.ICountryServices;
import company.tap.commondependencies.Currency.Currency;
import company.tap.commondependencies.Currency.ICurrencyServices;
import company.tap.commondependencies.Errors.Errors;
import company.tap.commondependencies.Errors.IErrorServices;
import company.tap.commondependencies.Helpers.DataUtilities;
import company.tap.commondependencies.Helpers.RestAPI;
import java.util.ArrayList;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;

@Service
class CurrencyServices
implements ICurrencyServices {
    final IErrorServices _errorServices;
    final ICountryServices _countryServices;
    private final String CommonApi = DataUtilities.getInstance().getUrlCommonUtilities();

    public CurrencyServices(IErrorServices _errorServices, ICountryServices _countryServices) {
        this._errorServices = _errorServices;
        this._countryServices = _countryServices;
    }

    private Currency getCurrency(String Code2) {
        try {
            HttpHeaders headersCA = new HttpHeaders();
            headersCA.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity entityToken = new HttpEntity((MultiValueMap)headersCA);
            return (Currency)RestAPI.getInstance().exchange(this.CommonApi + "currency/iso/" + Code2, HttpMethod.GET, entityToken, Currency.class, new Object[0]).getBody();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Currency getCurrencyByCountryIso2(String CountryCode) {
        return this.getCurrency(CountryCode);
    }

    @Override
    public Currency getCurrencyByCurrencyCode(String CurrencyCode) {
        return this.getCurrency(CurrencyCode);
    }

    @Override
    public Currency getCurrencyById(String CurrencyId) {
        try {
            HttpHeaders headersCA = new HttpHeaders();
            headersCA.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity entityToken = new HttpEntity((MultiValueMap)headersCA);
            return (Currency)RestAPI.getInstance().exchange(this.CommonApi + "currency/" + CurrencyId, HttpMethod.GET, entityToken, Currency.class, new Object[0]).getBody();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public ResponseEntity<Object> validateCurrencyCodeByCountry(String currencyCode, String countryCode) {
        Currency currency = this.getCurrency(currencyCode);
        if (currency == null) {
            return this._errorServices.Error(Errors.Not_Found.getCode(), Errors.Not_Found.toString(), "Invalid ISO CurrencyCode", HttpStatus.NOT_FOUND);
        }
        Country country = this._countryServices.getCountryByCountryIso(countryCode);
        if (country == null) {
            return this._errorServices.Error(Errors.Not_Found.getCode(), Errors.Not_Found.toString(), "Invalid ISO Country Code", HttpStatus.NOT_FOUND);
        }
        ArrayList<String> currencies = new ArrayList<String>();
        switch (country.getIso2()) {
            case "KW": {
                currencies.add("KWD");
                currencies.add("USD");
                if (currencies.contains(currency.getCode().getEnglish())) break;
                return this._errorServices.Error(Errors.Invalid_Data.getCode(), Errors.Invalid_Data.toString(), "Country doesnt support the provided currency code", HttpStatus.BAD_REQUEST);
            }
            case "AE": {
                currencies.add("AED");
                currencies.add("USD");
                if (currencies.contains(currency.getCode().getEnglish())) break;
                return this._errorServices.Error(Errors.Invalid_Data.getCode(), Errors.Invalid_Data.toString(), "Country doesnt support the provided currency code", HttpStatus.BAD_REQUEST);
            }
            case "SA": {
                currencies.add("SAR");
                currencies.add("USD");
                if (currencies.contains(currency.getCode().getEnglish())) break;
                return this._errorServices.Error(Errors.Invalid_Data.getCode(), Errors.Invalid_Data.toString(), "Country doesnt support the provided currency code", HttpStatus.BAD_REQUEST);
            }
            case "BH": {
                currencies.add("BHD");
                currencies.add("USD");
                if (currencies.contains(currency.getCode().getEnglish())) break;
                return this._errorServices.Error(Errors.Invalid_Data.getCode(), Errors.Invalid_Data.toString(), "Country doesnt support the provided currency code", HttpStatus.BAD_REQUEST);
            }
            case "OM": {
                currencies.add("OMR");
                currencies.add("USD");
                if (currencies.contains(currency.getCode().getEnglish())) break;
                return this._errorServices.Error(Errors.Invalid_Data.getCode(), Errors.Invalid_Data.toString(), "Country doesnt support the provided currency code", HttpStatus.BAD_REQUEST);
            }
            case "LB": 
            case "JO": {
                currencies.add("USD");
                if (currencies.contains(currency.getCode().getEnglish())) break;
                return this._errorServices.Error(Errors.Invalid_Data.getCode(), Errors.Invalid_Data.toString(), "Country doesnt support the provided currency code", HttpStatus.BAD_REQUEST);
            }
            case "EG": {
                currencies.add("USD");
                currencies.add("EGP");
                if (currencies.contains(currency.getCode().getEnglish())) break;
                return this._errorServices.Error(Errors.Invalid_Data.getCode(), Errors.Invalid_Data.toString(), "Country doesnt support the provided currency code", HttpStatus.BAD_REQUEST);
            }
            default: {
                currencies.add("USD");
                currencies.add("EUR");
                currencies.add("GBP");
                if (currencies.contains(currency.getCode().getEnglish())) break;
                return this._errorServices.Error(Errors.Invalid_Data.getCode(), Errors.Invalid_Data.toString(), "Country doesnt support the provided currency code", HttpStatus.BAD_REQUEST);
            }
        }
        return null;
    }
}

