/*
 * Decompiled with CFR 0.152.
 */
package company.tap.commondependencies.Operator;

import company.tap.commondependencies.Errors.Errors;
import company.tap.commondependencies.Errors.IErrorServices;
import company.tap.commondependencies.Helpers.DataUtilities;
import company.tap.commondependencies.Helpers.RestAPI;
import company.tap.commondependencies.Operator.IOperatorHelper;
import company.tap.commondependencies.Operator.PrivateOperator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;

@Service
class OperatorHelper
implements IOperatorHelper {
    private static final Logger logger = LogManager.getLogger(OperatorHelper.class);
    private final String tapApiUrl = DataUtilities.getInstance().getUrlTapApiV2();
    final IErrorServices _errorServices;

    public OperatorHelper(IErrorServices _errorServices) {
        this._errorServices = _errorServices;
    }

    @Override
    public PrivateOperator GetOperatorInfoByKey(String key) {
        try {
            HttpHeaders headersCA = new HttpHeaders();
            headersCA.setContentType(MediaType.APPLICATION_JSON);
            headersCA.set("Authorization", "Bearer " + key);
            HttpEntity entityToken = new HttpEntity((MultiValueMap)headersCA);
            return (PrivateOperator)RestAPI.getInstance().exchange(this.tapApiUrl + "operator/private/info", HttpMethod.GET, entityToken, PrivateOperator.class, new Object[0]).getBody();
        }
        catch (Exception e) {
            logger.info("----- GetOperatorInfoByKey Error -----");
            e.printStackTrace();
            logger.error((Object)e);
            return null;
        }
    }

    @Override
    public ResponseEntity<Object> ValidateOperatorByKey(String key, boolean tap, boolean isMerchant) {
        try {
            PrivateOperator operator = this.GetOperatorInfoByKey(key);
            if (operator == null) {
                return this._errorServices.Error(Errors.Api_key_unauthorised.getCode(), Errors.Api_key_unauthorised.toString(), "Api key is unauthorized to perform the operation", HttpStatus.UNAUTHORIZED);
            }
            if (!operator.getStatus().equalsIgnoreCase(DataUtilities.getInstance().getStatusActive())) {
                return this._errorServices.Error(Errors.InActive_Id.getCode(), Errors.InActive_Id.toString(), "Api key is unauthorized to perform the operation, Operator InActive", HttpStatus.UNAUTHORIZED);
            }
            if (tap && !operator.legacyId.equals("1300")) {
                return this._errorServices.Error(Errors.Api_key_unauthorised.getCode(), Errors.Api_key_unauthorised.toString(), "Api key is unauthorized to perform the operation", HttpStatus.UNAUTHORIZED);
            }
            if (isMerchant && !operator.isMerchant) {
                return this._errorServices.Error(Errors.Api_key_unauthorised.getCode(), Errors.Api_key_unauthorised.toString(), "Api key is unauthorized to perform the operation", HttpStatus.UNAUTHORIZED);
            }
            return null;
        }
        catch (Exception e) {
            logger.info("----- ValidateOperatorByKey Error -----");
            e.printStackTrace();
            logger.error((Object)e);
            return this._errorServices.Error(Errors.Internal_server_error.getCode(), Errors.Internal_server_error.toString(), "Failed to validate the key", HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
}

